#pragma once

#include "types.h"

#include <mail/nwsmtp/src/types.h>
#include <mail/nwsmtp/src/web/utils/exception.h>
#include <mail/nwsmtp/src/delivery/sync/types_reflection.h>
#include <mail/nwsmtp/src/web/send_mail/types_reflection.h>

#include <yamail/data/deserialization/json_reader.h>
#include <library/cpp/json/json_value.h>

namespace NNwSmtp::NWeb {

std::pair<TBuffer, TBuffer> ReadMultiPartBody(const std::vector<ymod_webserver::content_part>& parts);

std::pair<NJson::TJsonValue, TBuffer> ParseBody(const ymod_webserver::request_ptr& request);

template<typename TTag>
std::pair<TTag, TBuffer> ParseBodyTo(const ymod_webserver::request_ptr& request) {
    if (!request) {
        throw std::runtime_error("Empty request is not allowed");
    }
    if (request->content.type != "multipart") {
        throw std::logic_error("Expected multipart body, got: " + request->content.type);
    }

    auto [json, mime] = ReadMultiPartBody(request->childs);

    try {
        auto value = yamail::data::deserialization::fromJson<TTag>(std::string{json.cbegin(), json.cend()});
        return {value, mime};
    } catch (const std::exception &exc) {
        throw TMissingArgumentException(std::string(exc.what()));
    }
}

}  // namespace NNwSmtp::NWeb
