#include "response.h"

#include <library/cpp/json/json_writer.h>

namespace NNwSmtp::NWeb {

NJson::TJsonValue ToJson(const std::string& code, const std::string& message) {
    NJson::TJsonValue json;
    json["code"] = code.c_str();
    json["message"] = message.c_str();
    return json;
}

void Respond(THttpStream stream, EHttpCode ec, const NJson::TJsonValue& body) {
    stream->set_code(ec);
    stream->set_content_type("application/json");
    stream->result_body(NJson::WriteJson(body).c_str());
}

void RespondError(
    THttpStream stream,
    EHttpCode ec,
    const std::string& code,
    const std::string& message)
{
    auto json = ToJson(code, message);
    Respond(stream, ec, json);
}

}  // namespace NNwSmtp::NWeb
