#include "make_args.h"

#include <mail/nwsmtp/src/randgen.h>


namespace NNwSmtp::NWeb::NRestore {

NDlv::TEnvelopeInfo MakeEnvelopeInfo(const THttpStream& stream, const std::string& requestId) {
    NDlv::TEnvelopeInfo envelopeInfo;
    envelopeInfo.SessionId = stream->ctx()->uniq_id();
    envelopeInfo.RemoteIp = stream->ctx()->remote_address;
    envelopeInfo.RemoteHost = stream->ctx()->remote_address;
    envelopeInfo.EnvId = GenRandomString(8);
    envelopeInfo.RequestId = requestId;
    return envelopeInfo;
}

NDlv::TMailInfo MakeMailInfo(const TRequest& request) {
    if (request.MailInfo.Fid.empty()) {
        throw std::invalid_argument{"empty fid argument"};
    } else if (request.MailInfo.Stid.empty()) {
        throw std::invalid_argument{"empty stid argument"};
    } else if (request.MailInfo.Tab.empty()) {
        throw std::invalid_argument{"empty tab argument"};
    }
    return {
        .Fid = request.MailInfo.Fid,
        .ReceivedDate = request.MailInfo.ReceivedDate,
        .Labels = NDlv::TLabels{
            .System = request.MailInfo.System,
            .Symbol = request.MailInfo.Symbol,
            .Lids = request.MailInfo.Lids,
        },
        .Stid = request.MailInfo.Stid,
        .Tab = request.MailInfo.Tab,
    };
}

NDlv::TUserInfo MakeUserInfo(const TRequest& request, const std::string& uid) {
    if (request.UserInfo.Email.empty()) {
        throw std::invalid_argument{"empty email argument"};
    }
    if (uid.empty()) {
        throw std::invalid_argument{"empty uid argument"};
    }
    NDlv::TUserInfo userInfo;
    userInfo.Uid = uid;
    userInfo.Email = request.UserInfo.Email;
    return userInfo;
}

} // namespace NNwSmtp::NWeb::NRestore
