#include "make_response.h"
#include "reflection.h"

#include <mail/nwsmtp/src/delivery/sync/errors.h>

#include <mail/nwsmtp/src/web/utils/set_return_code.h>

#include <mail/yreflection/include/yamail/data/serialization/json_writer.h>

namespace NNwSmtp::NWeb::NRestore {

TErrorResponse MakeErrorResponse(const TErrorCode& ec, const NDlv::TSyncResult& result) {
    using EError = NNwSmtp::NDlv::EError;

    TErrorResponse response;
    response.Message = ec.message();

    if (ec == make_error_condition(EError::NslsPermanentError)) {
        response.Code = "NslsPermanentError";
    } else if (
        ec == make_error_condition(EError::MdsError) ||
        ec == make_error_condition(EError::SOError) ||
        ec == make_error_condition(EError::NslsTemporaryError)
    ) {
        response.Code = "ServiceUnavaliable";
    } else if (
        ec == make_error_condition(EError::BadMessage) ||
        ec == make_error_condition(EError::CycleDetected) ||
        ec == make_error_condition(EError::Exception)
    ) {
        response.Code = "RestoreError";
    } else if (ec == make_error_condition(EError::DuplicateFound)) {
        response.Code = "DuplicateError";
        response.Message = result.Mid;
    } else if (ec == make_error_condition(EError::StorageMailNotFound)) {
        response.Code = "StorageMailNotFound";
    } else if (ec == make_error_condition(EError::InvalidFid)) {
        response.Code = "InvalidFid";
    }

    return response;
}

void MakeResponse(const THttpStream& stream, const TErrorCode& ec, const NDlv::TSyncResult& result) {
    if (!ec) {
        TOkResponse response{result.Mid};
        yamail::data::serialization::JsonWriter<TOkResponse> writer(response);
        stream->set_code(EHttpCode::ok);
        stream->result_body(writer.result());
        return;
    }

    if (auto response = MakeErrorResponse(ec, result); response.Code.empty()) {
        stream->set_code(EHttpCode::internal_server_error);
    } else {
        SetReturnCode(stream, response.Code);
        yamail::data::serialization::JsonWriter<TErrorResponse> writer(response);
        stream->set_code(EHttpCode::not_acceptable);
        stream->result_body(writer.result());
    }
}

} // namespace NNwSmtp::NWeb::NRestore
