#include "make_args.h"

#include <mail/nwsmtp/src/randgen.h>

#include <mail/nwsmtp/src/web/utils/get_param.h>

#include <boost/lexical_cast/try_lexical_convert.hpp>

namespace NNwSmtp::NWeb::NSave {

NDlv::TEnvelopeInfo MakeEnvelopeInfo(const THttpStream& stream, const std::string& requestId) {
    NDlv::TEnvelopeInfo envelopeInfo;
    envelopeInfo.SessionId = stream->ctx()->uniq_id();
    envelopeInfo.RemoteIp = stream->ctx()->remote_address;
    envelopeInfo.RemoteHost = stream->ctx()->remote_address;
    envelopeInfo.EnvId = GenRandomString(8);
    envelopeInfo.RequestId = requestId;
    return envelopeInfo;
}

NDlv::TMailInfo MakeMailInfo(const TRequest& request) {
    std::time_t numericReceivedDate;
    auto receivedDate = GetParam(request->url.params, "received_date", "0");
    if (!boost::conversion::try_lexical_convert<std::time_t>(receivedDate, numericReceivedDate)) {
        throw std::invalid_argument{"invalid received_date argument"};
    }

    auto fid = GetParam(request->url.params, "fid", "");
    auto oldMid = GetParam(request->url.params, "old_mid", "");
    auto lids = GetVectorParam(request->url.params, "lid", {});
    auto system = GetVectorParam(request->url.params, "system", {});
    auto symbol = GetVectorParam(request->url.params, "symbol", {});

    return {
        .Fid = fid,
        .ReceivedDate = numericReceivedDate,
        .Labels = NDlv::TLabels{
            .System = system,
            .Symbol = symbol,
            .Lids = lids,
        },
        .OldMid = oldMid,
    };
}

NDlv::TUserInfo MakeUserInfo(const std::string& email, const std::string& uid) {
    if (email.empty()) {
        throw std::invalid_argument{"empty email argument"};
    }
    if (uid.empty()) {
        throw std::invalid_argument{"empty uid argument"};
    }

    return {
        .Uid = uid,
        .Email = email
    };
}

NDlv::TOptions MakeOptions(const TRequest& request) {
    auto detectVirus = GetParam(request->url.params, "detect_virus", "0");
    auto detectSpam = GetParam(request->url.params, "detect_spam", "0");

    return {
        .DetectSpam = detectSpam == "1",
        .DetectVirus = detectVirus == "1",
        .SoOut = true,
        .SkipMetaMsg = true,
        .DlvType = NDlv::EDlvType::Save
    };
}

} // namespace NNwSmtp::NWeb::NSave
