#include "make_response.h"
#include "reflection.h"

#include <mail/nwsmtp/src/delivery/sync/errors.h>

#include <mail/nwsmtp/src/web/utils/set_return_code.h>

#include <mail/yreflection/include/yamail/data/serialization/json_writer.h>

namespace NNwSmtp::NWeb::NSave {

TResponse MakeResponse(const TErrorCode& ec) {
    using EError = NNwSmtp::NDlv::EError;

    TResponse response;
    response.Explanation = ec.message();

    if (
        ec == make_error_condition(EError::MdsError) ||
        ec == make_error_condition(EError::SOError) ||
        ec == make_error_condition(EError::NslsTemporaryError) ||
        ec == make_error_condition(EError::AvirError)
    ) {
        response.Error = "ServiceUnavaliable";
    } else if (
        ec == make_error_condition(EError::BadMessage) ||
        ec == make_error_condition(EError::CycleDetected) ||
        ec == make_error_condition(EError::Exception) ||
        ec == make_error_condition(EError::DuplicateFound) ||
        ec == make_error_condition(EError::NslsPermanentError) ||
        ec == make_error_condition(EError::InvalidFid)
    ) {
        response.Error = "SendMessageFailed";
    } else if (ec == make_error_condition(EError::Virus)) {
        response.Error = "Virus";
    } else if (ec == make_error_condition(EError::Spam)) {
        response.Error = "Spam";
    } else if (ec == make_error_condition(EError::Malicious)) {
        response.Error = "StrongSpam";
    }

    return response;
}

void MakeResponse(const THttpStream& stream, const TErrorCode& ec, const NDlv::TSyncResult& result) {
    if (!ec) {
        TResponse response{.Error = "Success", .Mid = result.Mid};
        yamail::data::serialization::JsonWriter<TResponse> writer(response);
        stream->set_code(EHttpCode::ok);
        stream->result_body(writer.result());
        return;
    }

    if (auto response = MakeResponse(ec); response.Error.empty()) {
        stream->set_code(EHttpCode::internal_server_error);
    } else {
        SetReturnCode(stream, response.Error);
        yamail::data::serialization::JsonWriter<TResponse> writer(response);
        stream->set_code(EHttpCode::not_acceptable);
        stream->result_body(writer.result());
    }
}

} // namespace NNwSmtp::NWeb::NRestore
