#pragma once

#include <mail/nwsmtp/src/types.h>

#include <boost/asio.hpp>

#include <map>
#include <memory>
#include <vector>

namespace NNwSmtp::NWeb::NSendMail {

using TLabels = std::map<std::string, std::vector<std::string>>;

struct TArgs {
    std::string Uid;
    std::string FromEmail;
    std::string Service;

    std::optional<std::string> Ip;
    std::string RemoteIp;
    std::vector<std::string> Recipients; // to
    std::optional<std::vector<std::string>> RecipientsCopy; // cc
    std::optional<std::vector<std::string>> RecipientsHiddenCopy; // bcc
    std::optional<std::vector<std::string>> Lids;
    std::optional<std::vector<std::string>> SenderLabels;
    std::optional<std::vector<std::string>> CommonLabels;
    std::optional<TLabels> PersonalLabels;
    std::optional<std::string> Notify;
    std::optional<std::string> SaveToSent;
    std::optional<std::string> Host;
    std::string SpamCheck = "0";
    std::string AvirCheck = "0";
    std::string ContextId;
    boost::asio::ip::address RawIp;
    bool CheckMailFrom = true;

    TBuffer Message;

    TArgs() = default;

    TArgs(
        std::string&& ip,
        std::vector<std::string>&& recipients,
        std::vector<std::string>&& recipientsCopy,
        std::vector<std::string>&& recipientsHiddenCopy,
        std::vector<std::string>&& lids,
        std::vector<std::string>&& senderLabels,
        std::vector<std::string>&& commonLabels,
        TLabels&& personalLabels,
        std::string&& notify,
        std::string&& saveToSent,
        std::string&& host
    )
    : Ip(std::move(ip))
    , Recipients(std::move(recipients))
    , RecipientsCopy(std::move(recipientsCopy))
    , RecipientsHiddenCopy(std::move(recipientsHiddenCopy))
    , Lids(std::move(lids))
    , SenderLabels(std::move(senderLabels))
    , CommonLabels(std::move(commonLabels))
    , PersonalLabels(std::move(personalLabels))
    , Notify(std::move(notify))
    , SaveToSent(std::move(saveToSent))
    , Host(std::move(host)) {}
};

using TArgsPtr = std::shared_ptr<TArgs>;

} // namespace NNwSmtp::NWeb::NSendMail
