#pragma once

#include <mail/nwsmtp/src/options.h>
#include <mail/nwsmtp/src/router/settings.h>

#include <memory>

namespace NNwSmtp::NWeb::NSendMail {

struct TConfig {
    TConfig(
        bool checkSender,
        bool checkSenderSyntax,
        bool allowPercentHack,
        bool strictAsciiRecipient,
        RoutingSettings::Type primary,
        bool checkRcpt,
        Options::LLOpts corpList,
        bool bigMLUse,
        Options::DeliveryToSenderControl deliveryToSenderControl,
        std::uint32_t rcptCountLimit,
        std::string clusterName,
        std::string hostName,
        std::size_t messageSizeLimit
    )
        : CheckSender(checkSender)
        , CheckSenderSyntax(checkSenderSyntax)
        , AllowPercentHack(allowPercentHack)
        , StrictAsciiRecipient(strictAsciiRecipient)
        , Primary(primary)
        , CheckRcpt(checkRcpt)
        , CorpList(std::move(corpList))
        , BigMLUse(bigMLUse)
        , DeliveryToSenderControl(std::move(deliveryToSenderControl))
        , RcptCountLimit(rcptCountLimit)
        , ClusterName(std::move(clusterName))
        , HostName(std::move(hostName))
        , MessageSizeLimit(messageSizeLimit)
    { }

    bool CheckSender;
    bool CheckSenderSyntax;
    bool AllowPercentHack;
    bool StrictAsciiRecipient;
    RoutingSettings::Type Primary;
    bool CheckRcpt;
    Options::LLOpts CorpList;
    bool BigMLUse;
    Options::DeliveryToSenderControl DeliveryToSenderControl;
    std::uint32_t RcptCountLimit;
    std::string ClusterName;
    std::string HostName;
    std::size_t MessageSizeLimit;
};

using TConfigPtr = std::shared_ptr<TConfig>;

TConfigPtr MakeConfig(std::shared_ptr<Options> config);

} // namespace NNwSmtp::NWeb::NSendMail
