#pragma once

#include "args.h"

#include <mail/nwsmtp/src/web/types.h>
#include <mail/nwsmtp/src/xyandexhint/basics.h>

#include <mail/yplatform/include/yplatform/zerocopy/segment.h>
#include <mail/yplatform/include/yplatform/zerocopy/streambuf.h>

#include <vector>

namespace NNwSmtp::NWeb::NSendMail {

template <class T>
inline yplatform::zerocopy::segment MakeSegment(const T& x) {
    yplatform::zerocopy::streambuf buffer(512, 512);
    std::ostream stream(&buffer);
    stream << x << std::flush;
    return buffer.detach(buffer.end());
}

TXYandexHintFull MakeXYandexCommonHint(const TArgsPtr& args);
TXYandexHintFull MakeXYandexSenderHint(const TArgsPtr& args);
TXYandexHintFull MakeXYandexPersonalHint(const std::string& email, const std::vector<std::string>& labels);
std::string MakeAdditionalHeaders(const TArgsPtr& args);
void MakeRecipients(const TArgsPtr& args);
void MakeHostArgs(const TArgsPtr& args, const std::string& remoteIp);

yplatform::zerocopy::segment MakeSendMailXYandexHint(const TArgsPtr& args);
yplatform::zerocopy::segment MakeSendMailHeaders(const TArgsPtr& args);
TXYandexHint<NHint::TLabels, NHint::TLids> MakeSendSystemMailXYandexHint(const TArgsPtr& args);
yplatform::zerocopy::segment MakeSendSystemMailHeaders(const TArgsPtr& args);

TArgsPtr MakeArgs(
    const TRequest& request,
    std::string uid,
    std::string fromEmail,
    std::string service,
    std::string detectSpam,
    std::string detectVirus
);

TArgsPtr MakeArgs(
    const TRequest& request,
    std::string uid,
    std::string fromEmail,
    std::string service
);

} // namespace NNwSmtp::NWeb::NSendMail
