#include "error_code.h"
#include "make_response.h"

#include <mail/nwsmtp/src/web/utils/set_return_code.h>
#include <mail/nwsmtp/src/web/send_mail/utils.h>

#include <mail/yreflection/include/yamail/data/serialization/json_writer.h>

namespace NNwSmtp::NWeb::NSendMail {

TResponse MakeResponse(const TErrorCode& ec) {
    using EError = NWeb::NSendMail::EError;

    TResponse response;
    response.explanation = ec.message();

    if (ec == make_error_condition(EError::Spam)) {
        response.error = "Spam";
    } else if (ec == make_error_condition(EError::StrongSpam)) {
        response.error = "StrongSpam";
        response.ban_reason = GetBanReason(ec);
    } else if (ec == make_error_condition(EError::Virus)) {
        response.error = "Virus";
    } else if (
        ec == make_error_condition(EError::BadRecipient) ||
        ec == make_error_condition(EError::ReadOnlyMailList) ||
        ec == make_error_condition(EError::MailListWriteProhibited)
    ) {
        response.error = "BadRecipient";
    } else if (
        ec == make_error_condition(EError::TempBanUser) ||
        ec == make_error_condition(EError::BadKarma)
    ) {
        response.error = "BadKarmaBanTime";
    } else if (ec == make_error_condition(EError::SendMessageFailed)) {
        response.error = "SendMessageFailed";
    } else if (ec == make_error_condition(EError::FailedToAuthSender)) {
        response.error = "FailedToAuthSender";
        response.explanation = "Failed to authorize the sender";
    } else if (
        ec == make_error_condition(EError::PathToLong) ||
        ec == make_error_condition(EError::BadAddressSyntax) ||
        ec == make_error_condition(EError::BadSender)
    ) {
        response.error = "BadSender";
    } else if (ec == make_error_condition(EError::ToManyRecipients)) {
        response.error = "ToManyRecipients";
    } else if (ec == make_error_condition(EError::SizeLimitExceeded)) {
        response.error = "SizeLimitExceeded";
    }

    return response;
}

void Handler(THttpStream stream, TErrorCode ec) {
    if (!ec || ec == make_error_condition(EError::SendMessageDiscarded)) {
        TResponse response {"Success", "Ok", {}};
        yamail::data::serialization::JsonWriter<TResponse> writer(response);
        stream->set_code(EHttpCode::ok);
        stream->result_body(writer.result());
        return;
    }

    if (auto response = MakeResponse(ec); response.error.empty()) {
        stream->set_code(EHttpCode::internal_server_error);
    } else {
        SetReturnCode(stream, response.error);
        yamail::data::serialization::JsonWriter<TResponse> writer(response);
        stream->set_code(EHttpCode::not_acceptable);
        stream->result_body(writer.result());
    }
}

} // namespace NNwSmtp::NWeb::NSendMail
