#pragma once

#include "config.h"

#include <mail/nwsmtp/src/rcpts.h>
#include <mail/nwsmtp/src/rcpt_context.h>

#include <vector>

namespace NNwSmtp::NWeb::NSendMail {

bool CheckAt(const std::string& rcpt);

bool CheckStrictAscii(const std::string& rcpt, const TConfigPtr& config);

bool CheckPercent(const std::string& rcpt, const TConfigPtr& config);

std::string TransformPercentRecipient(const std::string& recipient, const TConfigPtr& config);

bool IsRouting(const TConfigPtr& config, const TRcptContextPtr& rcptContext);

bool IsBlackBoxRecipientCheck(const TConfigPtr& config, const TRcptContextPtr& rcptContext);

bool ValidateAddress(const std::string& address, const TConfigPtr& config);

bool IsBlackBoxMailFromCheck(const TConfigPtr& config, bool checkMailFrom);

std::string GetDomain(const std::string& address);

std::optional<std::string> GetBanReason(const TErrorCode& ec);

} // namespace NNwSmtp::NBlackBox
