#pragma once

#include "request.h"

#include <mail/nwsmtp/src/delivery/sync/types.h>


namespace NNwSmtp::NWeb::NSync {

using TRequest = std::tuple<
    NDlv::TEnvelopeInfo,
    NDlv::TMailInfo,
    NDlv::TUserInfo,
    NDlv::TOptions,
    TBuffer>;

NDlv::TEnvelopeInfo MakeEnvelope(THttpStream stream);

template <typename TTag>
TRequest ParseRequest(THttpStream stream) {
    auto [value, message] = ParseBodyTo<NDlv::TRequest>(stream->request());
    auto envInfo = MakeEnvelope(stream);
    return {envInfo, value.MailInfo, value.UserInfo, value.Options.value_or(NDlv::TOptions{}), message};
}

}  // namespace NNwSmtp::NWeb::NSync
