#include "sync_response.h"
#include "response.h"

#include <mail/nwsmtp/src/delivery/sync/errors.h>


namespace NNwSmtp::NWeb::NSync {

using NDlv::EError;
using EHttpCode::bad_request;
using EHttpCode::internal_server_error;
using EHttpCode::conflict;
using EHttpCode::not_acceptable;

template <>
NJson::TJsonValue ToJson<TMailishTag>(const NDlv::TSyncResult& result) {
    NJson::TJsonValue json;
    json["mid"] = result.Mid.c_str();
    json["imap_id"] = result.ImapId.c_str();
    return json;
}
template <>
NJson::TJsonValue ToJson<TRegularTag>(const NDlv::TSyncResult& result) {
    NJson::TJsonValue json;
    json["mid"] = result.Mid.c_str();
    return json;
}

std::string ToErrorCode(TErrorCode ec) {
    if (ec == make_error_condition(EError::BadMessage)) {
        return "bad_request";
    } else if (ec == make_error_condition(EError::DuplicateFound)) {
        return "duplicate_found";
    } else if (ec == make_error_condition(EError::CycleDetected)) {
        return "loop_detected";
    } else if (
        ec == make_error_condition(EError::NslsPermanentError) ||
        ec == make_error_condition(EError::NslsTemporaryError) ||
        ec == make_error_condition(EError::InvalidFid)
    ) {
        return "store_error";
    } else if (ec == make_error_condition(EError::Virus)) {
        return "rejected_virus";
    } else if (
        ec == make_error_condition(EError::Spam) ||
        ec == make_error_condition(EError::Malicious)
    ) {
        return "rejected_spam";
    } else {
        return "internal_server_error";
    }
}

EHttpCode ToHttpStatus(TErrorCode ec) {
    if (ec == make_error_condition(EError::BadMessage)) {
        return bad_request;
    } else if (
        ec == make_error_condition(EError::DuplicateFound) ||
        ec == make_error_condition(EError::CycleDetected) ||
        ec == make_error_condition(EError::NslsPermanentError) ||
        ec == make_error_condition(EError::InvalidFid)
    ) {
        return conflict;
    } else if (
        ec == make_error_condition(EError::Virus) ||
        ec == make_error_condition(EError::Spam) ||
        ec == make_error_condition(EError::Malicious)
    ) {
        return not_acceptable;
    } else {
        return internal_server_error;
    }
}

void RespondError(THttpStream stream, TErrorCode ec) {
    auto status = ToHttpStatus(ec);
    auto code = ToErrorCode(ec);
    return NNwSmtp::NWeb::RespondError(stream, status, code, ec.message());
}

}  // namespace NNwSmtp::NWeb::NSync
