#pragma once

#include "types.h"
#include "response.h"

#include <mail/nwsmtp/src/delivery/sync/sync.h>

#include <library/cpp/json/json_value.h>


namespace NNwSmtp::NWeb::NSync {

template <typename TTag>
NJson::TJsonValue ToJson(const NDlv::TSyncResult& result);

template <typename TTag>
void RespondSuccess(THttpStream stream, const NDlv::TSyncResult& result) {
    auto json = ToJson<TTag>(result);
    Respond(stream, EHttpCode::ok, json);
}

std::string ToErrorCode(TErrorCode ec);

EHttpCode ToHttpStatus(TErrorCode ec);

void RespondError(THttpStream stream, TErrorCode ec);

}  // namespace NNwSmtp::NWeb::NSync
