#pragma once

#include <mail/tvm_guard/ymod_tvm/ymod_tvm.h>

#include <memory>

namespace NNwSmtp::NWeb {

template <class TConfig, class TModule>
auto MakeTvmGuard(const TConfig& config, std::shared_ptr<TModule> modulePtr) {
    return std::make_shared<tvm_guard::Guard<TModule>>(
        tvm_guard::init(config, modulePtr)
    );
}

using TTvmModule = ymod_tvm::tvm2_module;
using TTvmGuardPtr = std::shared_ptr<tvm_guard::Guard<TTvmModule>>;

} //namespace NNwSmtp::NWeb
