#include "get_header.h"

#include <boost/algorithm/string.hpp>

namespace NNwSmtp::NWeb {

std::optional<std::string> GetOptionalHeader(const TRequest& request, const std::string& headerName) {
    const auto& header = request->headers.find(boost::algorithm::to_lower_copy(headerName));
    return header != request->headers.end() ?  std::make_optional(header->second) : std::nullopt;
}

} // namespace NNwSmtp::NWeb
