#include "get_param.h"

#include <boost/range/adaptor/transformed.hpp>

namespace NNwSmtp::NWeb {

std::vector<std::string> GetVectorParam(const std::multimap<std::string, std::string>& params, const std::string& name) {
    auto it = params.equal_range(name);
    if (it.first == params.end()) {
        throw std::invalid_argument("Invalid argument: " + name);
    }
    using paramsConstIteartorType = std::multimap<std::string, std::string>::const_iterator;
    auto result = boost::iterator_range<paramsConstIteartorType>(it.first, it.second)
        | boost::adaptors::transformed([&] (const auto& value) {
            return value.second;
        });
    return {result.begin(), result.end()};
}

std::vector<std::string> GetVectorParam(
    const std::multimap<std::string, std::string>& params,
    const std::string& name,
    const std::vector<std::string>& defaultValue
) {
    try {
        return GetVectorParam(params, name);
    } catch(std::invalid_argument&) {
        return defaultValue;
    }
}

std::string GetParam(
    const std::multimap<std::string, std::string>& params,
    const std::string& name,
    const std::string& defaultValue
) {
    try {
        if (auto param = GetVectorParam(params, name); param.empty()) {
            return defaultValue;
        } else {
            return param.front();
        }
    } catch(std::invalid_argument&) {
        return defaultValue;
    }
}

} // namespace NNwSmtp::NWeb
