#include "message_transforms.h"

#include <mail/nwsmtp/src/utils.h>

#include <boost/range/algorithm/copy.hpp>

namespace NNwSmtp::NWeb {

namespace {

const std::string CRLF = "\r\n";

struct TDotStuffer {
    void Unstuff(const TBuffer& message, TBuffer& result) {
        auto begin = message.cbegin();
        auto end = message.cend();

        for (auto now = begin; now != end; ++now) {
            switch (state) {
                case EState::NewLine: {
                    if (*now == '.') {
                        result.append(result.get_part(begin, now));
                        begin = ++now;
                        state = EState::InLine;
                    } else if (*now != '\n') {
                        state = EState::InLine;
                    }
                    break;
                }
                case EState::InLine: {
                    if (*now == '\n') {
                        state = EState::NewLine;
                    }
                    break;
                }
                default:
                    break;
            }
        }
        if (begin != end) {
            result.append(result.get_part(begin, end));
        }
    }

private:
    enum class EState {
        NewLine,
        InLine
    };

    EState state = EState::NewLine;
};

void UnDotstuffing(const TBuffer& message, TBuffer& result) {
    TDotStuffer dotStuffer;
    dotStuffer.Unstuff(message, result);
}

}

void AddEndingCRLF(std::string& message) {
    // MAILDLV-5798
    if (!boost::algorithm::ends_with(message, CRLF)) {
        message += CRLF;
    }
}

TBuffer StoreMessageTransforms(const TBuffer& message) {
    TBuffer result;
    UnDotstuffing(message, result);
    return result;
}

} // namespace NNwSmtp::NWeb
