#pragma once

#include <boost/optional.hpp>
#include <boost/lexical_cast.hpp>

#include <map>
#include <set>
#include <string>

namespace NNwSmtp::NHint {

using TParamsContainer = std::multimap<std::string, std::string>;

template <typename T>
inline void Extract(const TParamsContainer& from, const std::string& name, T& value) {
    try {
        auto it = from.find(name);
        if (it != from.end()) {
            value = boost::lexical_cast<T>(it->second);
        }
    } catch (...) {
        // TODO: log bad params
    }
}

template <typename T>
inline void Extract(const TParamsContainer& from, const std::string& name, std::set<T>& values) {
    try {
        auto range = from.equal_range(name);
        for (auto begin = range.first; begin != range.second; ++begin) {
            values.insert(boost::lexical_cast<T>(begin->second));
        }
    } catch (...) {
        // TODO: log bad params
    }
}

template <typename T>
void Extract(const TParamsContainer& from, const std::string& name, boost::optional<T>& optValue) {
    try {
        auto it = from.find(name);
        if (it != from.end()) {
            optValue = boost::lexical_cast<T>(it->second);
        }
    } catch (...) {
        // TODO: log bad params
    }
}

} // namespace NNwSmtp::NHint
