#pragma once

#include <mail/nwsmtp/src/xyandexhint/writer.h>
#include <mail/nwsmtp/src/xyandexhint/extractor.h>

namespace NNwSmtp::NHint {

template <typename T>
struct TParameterWrapper;

#define DECLARE_PARAMETER(ClassName, ParameterName, Type) \
    struct ClassName {\
        typedef Type ValueType;\
        ValueType value;\
    };\
    \
    template<>\
    struct TParameterWrapper<ClassName> {\
        void Write(std::ostream& stream) const {\
            ::NNwSmtp::NHint::Write(stream, ParameterName, parameter.value);\
        }\
        void Set(const ClassName& value) { parameter = value; }\
        void Fill(const TParamsContainer& from) {\
            ::NNwSmtp::NHint::Extract(from, ParameterName, parameter.value);\
        }\
        const auto & Get##ClassName() const { return parameter; }\
        const auto & Name() const { return ParameterName; }\
    private:\
        ClassName parameter;\
    };\


DECLARE_PARAMETER(TAllowAutoReply, "allow_autoreply", boost::optional<bool>)
DECLARE_PARAMETER(TBcc, "bcc", std::set<std::string>)
DECLARE_PARAMETER(TCopyToInbox, "copy_to_inbox", boost::optional<bool>)
DECLARE_PARAMETER(TDisablePush, "disable_push", boost::optional<bool>)
DECLARE_PARAMETER(TEmail, "email", std::string)
DECLARE_PARAMETER(TExternalImapId, "external_imap_id", std::string)
DECLARE_PARAMETER(TFid, "fid", std::string)
DECLARE_PARAMETER(TFilters, "filters", boost::optional<bool>)
DECLARE_PARAMETER(TFolder, "folder", std::string)
DECLARE_PARAMETER(TFolderPath, "folder_path", std::string)
DECLARE_PARAMETER(TFolderPathDelim, "folder_path_delim", std::string)
DECLARE_PARAMETER(TForward, "forward", boost::optional<bool>)
DECLARE_PARAMETER(THdrDate, "hdr_date", boost::optional<std::time_t>)
DECLARE_PARAMETER(THost, "host", std::string)
DECLARE_PARAMETER(TImap, "imap", boost::optional<bool>)
DECLARE_PARAMETER(TImapLabels, "imaplabel", std::set<std::string>)
DECLARE_PARAMETER(TIpFrom, "ipfrom", std::string)
DECLARE_PARAMETER(TLabels, "label", std::set<std::string>)
DECLARE_PARAMETER(TLids, "lid", std::set<std::string>)
DECLARE_PARAMETER(TMethodId, "method_id", std::string)
DECLARE_PARAMETER(TMid, "mid", std::string)
DECLARE_PARAMETER(TMixed, "mixed", boost::optional<std::size_t>)
DECLARE_PARAMETER(TNotify, "notify", boost::optional<bool>)
DECLARE_PARAMETER(TReceivedDate, "received_date", boost::optional<std::time_t>)
DECLARE_PARAMETER(TSaveToSent, "save_to_sent", boost::optional<bool>)
DECLARE_PARAMETER(TSessionKey, "session_key", std::string)
DECLARE_PARAMETER(TSkipLoopPrevention, "skip_loop_prevention", boost::optional<bool>)
DECLARE_PARAMETER(TSkipMetaMsg, "skip_meta_msg", boost::optional<bool>)
DECLARE_PARAMETER(TSource, "source", std::string)
DECLARE_PARAMETER(TSourceStid, "source_stid", std::string)
DECLARE_PARAMETER(TSourceSuid, "source_suid", std::string)
DECLARE_PARAMETER(TUserLabels, "userlabel", std::set<std::string>)
DECLARE_PARAMETER(TSyncDlv, "sync_dlv", boost::optional<bool>);

} // namespace NNwSmtp::NHint
