#pragma once

#include <mail/nwsmtp/src/xyandexhint/extractor.h>

#include <yplatform/encoding/base64.h>

#include <boost/algorithm/string/trim.hpp>
#include <boost/tokenizer.hpp>

namespace NNwSmtp::NHint {

inline void Parse(const std::string& parametersStr, TParamsContainer& container) {
    using separator = boost::char_separator<char>;
    separator sep("\n");
    boost::tokenizer<separator> tokens(parametersStr, separator("\n"));

    for (const auto & t : tokens) {
        auto token = boost::trim_copy(t);
        auto eqPos = token.find('=');
        if (eqPos == std::string::npos)
            continue;
        auto key = token.substr(0, eqPos);
        boost::trim(key);
        auto value = token.substr(eqPos + 1);
        boost::trim(value);
        container.insert({key, value});
    }
}

inline void ParseBase64(const std::string& base64Str, TParamsContainer& container) {
    try {
        auto decoded = yplatform::base64_decode(base64Str.begin(), base64Str.end());
        std::string decodedStr(decoded.begin(), decoded.end());
        Parse(decodedStr, container);
    } catch (...) {
        // TODO log bad hint
    }
}

}  // namespace NNwSmtp::NHint
