#pragma once

#include <mail/nwsmtp/src/xyandexhint/parser.h>

#include <boost/optional.hpp>

#include <string>
#include <ostream>

namespace NNwSmtp::NHint {

template <typename T>
inline void Write(std::ostream& stream, const std::string& name, const T& value) {
    stream << name << '=' << value << '\n';
}

template <>
inline void Write<std::string>(std::ostream& stream, const std::string& name, const std::string& value) {
    if (!value.empty()) {
        stream << name << '=' << value << '\n';
    }
}

template <typename T>
inline void Write(std::ostream& stream, const std::string& name, const boost::optional<T>& optValue) {
    if (optValue) {
        Write(stream, name, optValue.value());
    }
}

template <typename T>
inline void Write(std::ostream& stream, const std::string& name, const std::set<T>& values) {
    for (const auto & val : values) {
        Write(stream, name, val);
    }
}

inline void Write(std::ostream& stream, const TParamsContainer& params) {
    for (const auto& pair : params) {
        Write(stream, pair.first, pair.second);
    }
}

} // namespace NNwSmtp::NHint
