#pragma once

#include <mail/nwsmtp/src/xyandexhint/parameters.h>
#include <mail/nwsmtp/src/xyandexhint/parser.h>
#include <mail/nwsmtp/src/xyandexhint/extractor.h>

namespace NNwSmtp {
namespace NHint {

template<typename... Ts>
struct TComposer: TParameterWrapper<Ts>... {
    void Write(std::ostream& stream) const {
        (TParameterWrapper<Ts>::Write(stream), ...);
    }

    void Fill(const TParamsContainer& container) {
        (TParameterWrapper<Ts>::Fill(container), ...);
    }

    template <typename... Args>
    void Set(Args&&... args) {
        (TParameterWrapper<Args>::Set(std::forward<Args>(args)), ...);
    }
};

} // namespace NHint

template <typename... Ts>
struct TXYandexHint: NHint::TComposer<Ts...> {
    using ThisComposer = NHint::TComposer<Ts...>;
    using TParamsContainer = NHint::TParamsContainer;

    TXYandexHint() {}

    template <typename... Args>
    TXYandexHint(Args&&... args) {
        ThisComposer::Set(std::forward<Args>(args)...);
    }

    friend std::ostream& operator<<(std::ostream& out, const TXYandexHint<Ts...>& params) {
        std::ostringstream oss;
        params.Write(oss);
        auto str = oss.str();
        auto encoded = yplatform::base64_encode(str.begin(), str.end());
        out << "X-Yandex-Hint: " << encoded << "\r\n";
        return out;
    }

    std::string Str() const {
        std::ostringstream oss;
        oss << *this;
        return oss.str();
    }

    void Fill(const std::string& base64str) {
        TParamsContainer container;
        NHint::ParseBase64(base64str, container);
        ThisComposer::Fill(container);
    }

    void Fill(const TParamsContainer& container) {
        ThisComposer::Fill(container);
    }
};

template<typename... Ts> TXYandexHint(Ts...) -> TXYandexHint<Ts...>;

inline std::string MakeHintValueFromParams(const NHint::TParamsContainer& container) {
    std::ostringstream oss;
    NHint::Write(oss, container);
    auto str = oss.str();
    auto encoded = yplatform::base64_encode(str.begin(), str.end());
    return std::string{encoded.begin(), encoded.end()};
}

inline std::string MakeHintFromParams(const NHint::TParamsContainer& container) {
    return "X-Yandex-Hint: " + MakeHintValueFromParams(container) + "\r\n";
}

} // NNwSmtp
