LIBRARY()

OWNER(
    g:mproto
)

NO_UTIL()

CFLAGS(
    -DBOOST_SPIRIT_THREADSAFE
    -DBOOST_SPIRIT_USE_PHOENIX_V3
    -DBOOST_CHRONO_VERSION=2
)

PEERDIR(
    mail/butil
    mail/logdog
    mail/so/api
    mail/sova/src
    mail/ymod_httpclient
    mail/ymod_smtpclient
    mail/ymod_smtpserver/src
    mail/ymod_ratesrv
    mail/ymod_ratesrv/helper
    mail/ymod_mds
    mail/ymod_tvm
    mail/ymod_webserver
    mail/library/dsn
    mail/library/received_header
    mail/tvm_guard/ymod_tvm
    contrib/libs/yajl
    contrib/libs/libopendmarc
    contrib/libs/libopendkim
    contrib/libs/libspf2
    mail/contrib/spdlog
    mail/mail_getter
)

ADDINCL(
    mail/butil/include
    mail/sova/include
    mail/ymod_smtpserver/include
    mail/nwsmtp/src
    GLOBAL contrib/libs/yajl
    contrib/libs/libopendkim
    mail/contrib/spdlog/include
)

GENERATE_ENUM_SERIALIZATION(auth.h)
GENERATE_ENUM_SERIALIZATION(control_from/options.h)

SRCS(
    address_parser.cpp
    aliases.cpp
    avir/client_impl.cpp
    auth/impl.cpp
    auth/utils.cpp
    big_ml/client_impl.cpp
    big_ml/errors.cpp
    big_ml/utils.cpp
    bb_get_result.cpp
    blackbox/bb_checks_impl.cpp
    blackbox/bb_client_impl.cpp
    blackbox/config.cpp
    blackbox/request.cpp
    blackbox/response.cpp
    context.cpp
    control_from/control_from.cpp
    control_from/options.cpp
    control_from/errors.cpp
    control_from/white_list.cpp
    delivery/async/async.cpp
    delivery/async/async_impl.cpp
    delivery/async/delivery.cpp
    delivery/async/read_headers.cpp
    delivery/async/route_calculator.cpp
    delivery/async/prepare_delivery.cpp
    delivery/async/prepare_headers.cpp
    delivery/async/log_stats.cpp
    delivery/async/so.cpp
    delivery/async/utils.cpp
    delivery/sync/config.cpp
    delivery/sync/errors.cpp
    delivery/sync/hint.cpp
    delivery/sync/sync.cpp
    delivery/sync/types.cpp
    delivery/sync/utils.cpp
    dkim/adkim.cpp
    GLOBAL dkim/dkim_module.cpp
    dkim/dkim_options.cpp
    dkim/signature_parser.cpp
    dmarc/alignment.cpp
    dmarc/alignment_mode.cpp
    dmarc/context.cpp
    dmarc.cpp
    dmarc/dmarc.cpp
    dmarc/dmarc_policy.cpp
    dmarc/domain_policy.cpp
    dmarc/failure_options.cpp
    dmarc/outcome.cpp
    dmarc/parser.cpp
    dmarc/policy_manager.cpp
    dmarc/spf_origin.cpp
    dmarc/util.cpp
    domains_set.cpp
    envelope.cpp
    fouras/client.cpp
    fouras/parser.cpp
    fouras/errors.cpp
    header_storage.cpp
    log.cpp
    mailfrom/command_impl.cpp
    mailfrom/convert_ec_to_smtp_answer.cpp
    match.cpp
    mds/client_impl.cpp
    ml/client_impl.cpp
    nsls/client_impl.cpp
    nsls/make_response.cpp
    options.cpp
    public_suffix_list.cpp
    randgen.cpp
    ratesrv/checks.cpp
    ratesrv/error_code.cpp
    rcpts.cpp
    GLOBAL recognizer/recognizer_impl.cpp
    resolver/client_impl.cpp
    GLOBAL resolver/resolver.cpp
    rcpt_to/rcpt_to_impl.cpp
    rcpt_to/rcpt_to.cpp
    rcpt_to/config.cpp
    rcpt_to/expand_alias.cpp
    rcpt_to/utils.cpp
    router/router.cpp
    router/settings.cpp
    GLOBAL rate_limiter/impl.cpp
    smtp_server/session_impl.cpp
    smtp_server/smtp_fsm.cpp
    GLOBAL smtp_server/server_stub.cpp
    smtp_client/smtp_client.cpp
    smtp_client/smtp_targeting.cpp
    smtp_client/utils.cpp
    so/config.cpp
    so/client_impl.cpp
    so/request.cpp
    so/to_protobuf.cpp
    so/utils.cpp
    spf/aspf_impl.cpp
    spf/config.cpp
    utils.cpp
    web/handle_restore.cpp
    web/handle_save.cpp
    web/handle_send_mail.cpp
    web/handle_send_system_mail.cpp
    web/handle_store_mailish.cpp
    web/handle_store.cpp
    web/response.cpp
    web/restore/make_args.cpp
    web/restore/make_response.cpp
    web/request.cpp
    web/sync_request.cpp
    web/sync_response.cpp
    web/save/make_args.cpp
    web/save/make_response.cpp
    web/send_mail/config.cpp
    web/send_mail/make_args.cpp
    web/send_mail/make_response.cpp
    web/send_mail/send_mail.cpp
    web/send_mail/utils.cpp
    web/utils/get_header.cpp
    web/utils/get_param.cpp
    web/utils/message_transforms.cpp
    web/utils/set_return_code.cpp
    yarm/client_impl.cpp
    yarm/error_code.cpp
    nwsmtp/impl.cpp
    GLOBAL web/web.cpp
)

END()
