#pragma once

#include "client.h"

#include <mail/nwsmtp/src/context.h>
#include <mail/nwsmtp/src/options.h>
#include <mail/ymod_httpclient/include/ymod_httpclient/call.h>

#include <boost/asio.hpp>

#include <string>

namespace NNwSmtp::NYarm {

class TClientImpl: public IClient {
public:
    using THttpClientPtr = std::shared_ptr<ymod_httpclient::cluster_call>;

    TClientImpl(const Options::YarmOpts& options, THttpClientPtr httpClient, boost::asio::io_context& io);

    void AsyncRun(TContextPtr context, TRequest request, TCallback callback) override;

private:
    static void HandleAsyncRun(
        TContextPtr context,
        std::string email,
        TCallback callback,
        TErrorCode errc,
        yhttp::response httpResponse
    );

    const std::string Secret;
    THttpClientPtr HttpClient;
    boost::asio::io_context& Io;
};

} // namespace NNwSmtp::NYarm
