#include "error_code.h"

namespace NNwSmtp::NYarm {

const char* TErrorCategory::name() const noexcept {
    return "nwsmtp.yarm";
}

std::string TErrorCategory::message(int value) const {
    switch (static_cast<EError>(value)) {
        case EError::ParseError:
            return "Failed to parse response";
        case EError::NotFound:
            return "Authentication info not found";
        default:
            return "Unknown YARM client error code: " + std::to_string(value);
    }
}

static const TErrorCategory& GetErrorCategory() {
    static const TErrorCategory errorCategory;
    return errorCategory;
}

boost::system::error_code make_error_code(EError ec) {
    return boost::system::error_code(static_cast<int>(ec), GetErrorCategory());
}

} // namespace NNwSmtp::NYarm
