#pragma once

#include <boost/system/error_code.hpp>

namespace NNwSmtp::NYarm {

enum class EError {
    ParseError = 1,
    NotFound,
    OtherError,
};

} // namespace NNwSmtp::NYarm

namespace boost::system {

template <>
struct is_error_code_enum<NNwSmtp::NYarm::EError>: std::true_type
{};

} // namespace boost::system

namespace NNwSmtp::NYarm {

class TErrorCategory final: public boost::system::error_category {
public:
    const char* name() const noexcept override;
    std::string message(int) const override;
};

boost::system::error_code make_error_code(EError ec);

} // namespace NNwSmtp::NYarm
