#pragma once

#include <mail/nwsmtp/src/types.h>

#include <optional>
#include <string>

namespace NNwSmtp::NYarm {

struct TRequest {
    std::string Uid;
    std::string Email;
};

struct TError {
    std::string Description;
};

struct TSmtpData {
    std::string Login;
    std::string PasswordOrToken;
    bool IsOauth;
};

struct TSmtpDataResponse {
    std::optional<TSmtpData> SmtpData;
    std::optional<TError> Error;
};

struct TResponse {
    std::string Login;
    std::string PasswordOrToken;
    bool IsOauth;
};

using TCallback = std::function<void(TErrorCode, TResponse)>;

} // namespace NNwSmtp::NYarm
