#include "avir_client_mock.h"

#include <mail/nwsmtp/src/avir/client_impl.h>
#include <mail/nwsmtp/src/avir/types.h>
#include <mail/nwsmtp/src/utils.h>

#include <mail/nwsmtp/ut/test_with_spawn.h>

#include <gtest/gtest.h>
#include <gmock/gmock.h>

#include <boost/asio.hpp>

namespace {

using namespace testing;
using namespace NTesting;
using namespace NNwSmtp;
using namespace NNwSmtp::NAvir;

struct TTestAvirCheckClient: TTestWithSpawn {
    const std::shared_ptr<StrictMock<TAvirClientMock>> AvirClientMock =
        std::make_shared<StrictMock<TAvirClientMock>>(Io);
    const std::shared_ptr<TAvirCheckClient> AvirCheckClient = std::make_shared<TAvirCheckClient>(AvirClientMock, Io);

    TContextPtr Context = boost::make_shared<TContext>("","","","");
    std::string Message = "Header-1: 1\r\nHeader-2: 2\r\n\r\nBody";
    NNwSmtp::TBuffer PlatformZeroCopyMessage = NUtil::MakeSegment(Message);

    template <typename THandler, typename Buffer>
    TStatus Check(
        THandler handler,
        Buffer buffer
    ) {
        boost::asio::async_completion<
            THandler,
            void(TErrorCode, TStatus)
        > init(handler);
        AvirCheckClient->Check(Context, buffer, init.completion_handler);
        return init.result.get();
    }
};


TEST_F(TTestAvirCheckClient, for_message_check_request_ended_with_error_should_return_error) {
    WithSpawn([this](boost::asio::yield_context yield) {
        EXPECT_CALL(*AvirClientMock, check(_, _, _, 32))
            .WillOnce(InvokeArgument<0>(ymod_httpclient::http_error::code::ssl_error, TStatus::unknown));

        TErrorCode ec;
        Check(yield[ec], PlatformZeroCopyMessage);
        ASSERT_TRUE(ec);
        EXPECT_EQ(ec, ymod_httpclient::http_error::code::ssl_error);
    });
}

TEST_F(TTestAvirCheckClient, for_successful_message_check_should_return_status) {
    WithSpawn([this](boost::asio::yield_context yield) {
        EXPECT_CALL(*AvirClientMock, check(_, _, _, 32))
            .WillOnce(InvokeArgument<0>(TErrorCode{}, TStatus::clean));

        TErrorCode ec;
        auto status = Check(yield[ec], PlatformZeroCopyMessage);
        ASSERT_FALSE(ec);
        EXPECT_EQ(status, TStatus::clean);
    });
}

} // namespace anonymous
