#pragma once

#include <gmock/gmock.h>

#include <mail/nwsmtp/src/blackbox/bb_client.h>
#include <mail/nwsmtp/src/blackbox/request.h>

#include <boost/fusion/adapted.hpp>
#include <boost/fusion/include/equal_to.hpp>

BOOST_FUSION_ADAPT_STRUCT(NNwSmtp::NBlackBox::TResponse,
    Login,
    Suid,
    Uid,
    DefaultEmail,
    Hosted,
    CatchAll,
    Domain,
    Country,
    OrgId,
    PhoneConfirmed,
    IsCorpList,
    IsMailList,
    IsBlocked,
    IsAssessor,
    HasPDDsid,
    AppPasswordEnabled,
    RegistrationDate,
    BornDate,
    Mdb,
    Karma,
    KarmaStatus,
    KarmaBanTime,
    Scopes,
    AuthSuccess,
    ErrorStr
)

BOOST_FUSION_ADAPT_STRUCT(NNwSmtp::NBlackBox::TRequest,
    Login,
    UserIp,
    Password,
    OauthToken,
    DbFields,
    Attributes
)

BOOST_FUSION_ADAPT_STRUCT(NNwSmtp::NBlackBox::NClient::THttpRequest,
    Url,
    Body
)

namespace NNwSmtp::NBlackBox {

namespace NClient {

inline bool operator==(const THttpRequest& lhs, const THttpRequest& rhs) {
    return boost::fusion::operator==(lhs, rhs);
}

namespace NTest {

struct TBBClientMock: IBBClient {
    MOCK_METHOD(void, UserInfo, (TContextPtr, THttpRequest, TResponseCallback), (override));
    MOCK_METHOD(void, Login, (TContextPtr, THttpRequest, TResponseCallback), (override));
    MOCK_METHOD(void, Oauth, (TContextPtr, THttpRequest, TResponseCallback), (override));
};

} // namespace NTest

} // namespace NClient

inline bool operator==(const TResponse& lhs, const TResponse& rhs) {
    return boost::fusion::operator==(lhs, rhs);
}

inline bool operator==(const TRequest& lhs, const TRequest& rhs) {
    return boost::fusion::operator==(lhs, rhs);
}

} // namespace NNwSmtp::NBlackBox
