#include <mail/nwsmtp/src/control_from/control_from.h>
#include <mail/nwsmtp/src/utils.h>
#include <mail/nwsmtp/src/types.h>

#include <string>

#include <gtest/gtest.h>

using namespace NNwSmtp;
using namespace NNwSmtp::NControlFrom;

class TControlFromParseEmailTest : public testing::Test {
public:
    void SetUp() override {
    }

    auto MakeHeaderRange(const std::string& header) {
        Buffer = NNwSmtp::NUtil::MakeSegment(header);
        return TBufferRange(Buffer.cbegin(), Buffer.cend());
    }

    auto ParseEmail(const std::string& headerStr) {
        auto header = MakeHeaderRange(headerStr);
        return control_from::parseEmail(header);
    }
private:
    NNwSmtp::TBuffer Buffer;
};

struct TControlFromParseEmailTestWithHeaderParam
     : public TControlFromParseEmailTest, public testing::WithParamInterface<std::string> {};

TEST_F(TControlFromParseEmailTest, GoodEmailSuccess) {
    ASSERT_EQ(ParseEmail("foo@yandex.ru"), "foo@yandex.ru");
}

TEST_F(TControlFromParseEmailTest, EmptyHeaderReturnsEmptyEmail) {
    ASSERT_EQ(ParseEmail(""), "");
}

TEST_F(TControlFromParseEmailTest, TakeFirstWhenManyEmails) {
    ASSERT_EQ(ParseEmail("foo@yandex.ru, bar@yandex.ru"), "foo@yandex.ru");
}

TEST_F(TControlFromParseEmailTest, WhenNoLocalPartReturnsEmptyEmail) {
    ASSERT_EQ(ParseEmail("foo.bar.ru"), "");
}

TEST_P(TControlFromParseEmailTestWithHeaderParam, WhenEmailsBrokenReturnsEmptyEmail) {
    ASSERT_EQ(ParseEmail(GetParam()), "");
}

INSTANTIATE_TEST_SUITE_P(HeaderString, TControlFromParseEmailTestWithHeaderParam,
     testing::Values(
        "]foo@yandex.ru",
        ">foo@yandex.ru",
        "myevilstring>foo@yandex.ru",
        "myevilstring foo@yandex.ru",
        "myevilstring\tfoo@yandex.ru",
        "myevilstring@foo@yandex.ru"
     ));
