#pragma once

#include <mail/nwsmtp/src/so/types_reflection.h>
#include <mail/nwsmtp/src/avir/client.h>
#include <mail/nwsmtp/src/context.h>
#include <mail/nwsmtp/src/delivery/sync/types.h>
#include <mail/nwsmtp/src/mds/client.h>
#include <mail/nwsmtp/src/mds/types.h>
#include <mail/nwsmtp/src/nsls/client.h>
#include <mail/nwsmtp/src/nsls/types_reflection.h>
#include <mail/nwsmtp/src/resolver/client.h>
#include <mail/nwsmtp/src/so/client.h>
#include <mail/nwsmtp/src/utils.h>

#include <mail/yplatform/include/yplatform/zerocopy/segment.h>

#include <gtest/gtest.h>
#include <gmock/gmock.h>

namespace NTesting::NMocks {

using namespace NNwSmtp;

struct TMdsClientMock: NMds::IMdsClient {
    MOCK_METHOD(void, Put, (TContextPtr, NMds::TPutRequest, NMds::TGetPutCallback));
    MOCK_METHOD(void, Get, (TContextPtr, std::string, NMds::TGetPutCallback));
};

struct TResolverClient: NDns::IResolverClient {
    MOCK_METHOD(void, ResolveIp, (TContextPtr, std::string, TCallback));
};

struct TNslsClient: NNsls::INslsClient {
    MOCK_METHOD(void, Store, (TContextPtr, NNsls::TRequest, NNsls::TCallback));
};

struct TAvirClient: NAvir::IAvirCheckClient {
    MOCK_METHOD(void, Check, (TContextPtr, NNwSmtp::TBuffer, NAvir::TCallback));
};

struct TSOClientMock: NSO::ISOClient {
    MOCK_METHOD(void, Check, (TContextPtr, NSO::TRequestPtr, NSO::TCallback));
};

} // namespace NTesting

namespace NNwSmtp {

template <class THeaders>
std::string HeadersToString(const THeaders& headers) {
    std::string result;
    boost::range::for_each(headers.GetAllHeaders(), [&](auto header) {
        if (NUtil::ToString(header.Name) == "Received") {
            return;
        }
        result += NUtil::ToString(header.GetWhole()) + "\r\n";
    });
    return result;
}

template <>
std::string HeadersToString<TBuffer>(const TBuffer& value) {
    const auto& [headers, _] = ParseMessage(value);
    return HeadersToString(headers);
}

} // namespace NNwSmtp

namespace NNwSmtp::NMds {

static bool operator ==(const TPutRequest& lhs, const TPutRequest& rhs) {
    using namespace NNwSmtp::NUtil;
    return lhs.Uid == rhs.Uid
        && lhs.IsSpam == rhs.IsSpam
        && HeadersToString(lhs.Headers) == HeadersToString(rhs.Headers)
        && ToString(lhs.Body) == ToString(rhs.Body)
        && HeadersToString(lhs.AddedHeaders) == HeadersToString(rhs.AddedHeaders);
}

} // namespace NNwSmtp::NMds

namespace NNwSmtp::NNsls {

static bool operator ==(const TMailFrom& lhs, const TMailFrom& rhs) {
    return boost::fusion::operator==(lhs, rhs);
}

static bool operator ==(const TEnvelope& lhs, const TEnvelope& rhs) {
    return boost::fusion::operator==(lhs, rhs);
}

static bool operator ==(const TMessage& lhs, const TMessage& rhs) {
    return lhs.stid == rhs.stid
        && lhs.front == rhs.front
        && lhs.spam == rhs.spam
        && lhs.hints == rhs.hints;
}

static bool operator ==(const TDeliveryResult& lhs, const TDeliveryResult& rhs) {
    return boost::fusion::operator==(lhs, rhs);
}

static bool operator ==(const TNotification& lhs, const TNotification& rhs) {
    return boost::fusion::operator==(lhs, rhs);
}

static bool operator ==(const TRecipient& lhs, const TRecipient& rhs) {
    return boost::fusion::operator==(lhs, rhs);
}

static bool operator ==(const TRequest& lhs, const TRequest& rhs) {
    return boost::fusion::operator==(lhs, rhs);
}

} // namespace NNwSmtp::NNsls

namespace NNwSmtp::NDlv {

static bool operator ==(const TSyncResult& lhs, const TSyncResult& rhs) {
    return lhs.Mid == rhs.Mid
        && lhs.ImapId == rhs.ImapId;
}

} // namespace NNwSmtp::NDlv

namespace yplatform::zerocopy {

static bool operator ==(const yplatform::zerocopy::segment& lhs, const yplatform::zerocopy::segment& rhs) {
    return NNwSmtp::NUtil::ToString(lhs)== NNwSmtp::NUtil::ToString(rhs);
}

} // namespace yplatform::zerocopy

namespace NNwSmtp::NSO {

static bool operator ==(const TConnectInfo& lhs, const TConnectInfo& rhs) {
    return boost::fusion::operator==(lhs, rhs);
}

static bool operator ==(const TEmail& lhs, const TEmail& rhs) {
    return boost::fusion::operator==(lhs, rhs);
}

static bool operator ==(const TEmailInfo& lhs, const TEmailInfo& rhs) {
    return boost::fusion::operator==(lhs, rhs);
}

static bool operator ==(const TEnvelope& lhs, const TEnvelope& rhs) {
    return boost::fusion::operator==(lhs, rhs);
}

static bool operator ==(const TRequest& lhs, const TRequest& rhs) {
    return boost::fusion::operator==(lhs, rhs);
}

} // namespace NNwSmtp::NSO
