#include <mail/nwsmtp/src/delivery/sync/errors.h>
#include <mail/nwsmtp/src/nsls/error_code.h>
#include <mail/nwsmtp/src/so/errors.h>
#include <mail/nwsmtp/src/types.h>

#include <mail/ymod_mds/src/errors.h>

#include <gtest/gtest.h>
#include <gmock/gmock.h>

namespace {

using namespace testing;
using namespace NNwSmtp;
using namespace NDlv;

struct TestSyncDlvErrors: TestWithParam<std::tuple<TErrorCode, EError>> {
};

TEST_P(TestSyncDlvErrors, test_equivalent_error_code) {
    EXPECT_TRUE(std::get<0>(GetParam()) == make_error_condition(std::get<1>(GetParam())));
}

INSTANTIATE_TEST_SUITE_P(
    test_equivalent_error_code,
    TestSyncDlvErrors,
    Values(
        std::make_tuple(
            make_error_code(NMds::EError::StorageError),
            EError::MdsError
        ),
        std::make_tuple(
            make_error_code(NMds::EError::StorageMailNotFound),
            EError::StorageMailNotFound
        ),
        std::make_tuple(
            make_error_code(NNsls::EError::EC_PERM_ERROR),
            EError::NslsPermanentError
        ),
        std::make_tuple(
            make_error_code(NNsls::EError::EC_PARSE_ERROR),
            EError::NslsTemporaryError
        ),
        std::make_tuple(
            make_error_code(NNsls::EError::EC_BAD_STATUS),
            EError::NslsTemporaryError
        ),
        std::make_tuple(
            make_error_code(NSO::EError::ParseError),
            EError::SOError
        ),
        std::make_tuple(
            make_error_code(NSO::EError::BadStatus),
            EError::SOError
        )
    )
);

} // namespace anonymous
