#include <mail/nwsmtp/src/dkim/adkim.h>

#include <gtest/gtest.h>

using namespace NNwSmtp;

TEST(CommonDomainDepth, Equal) {
    ASSERT_EQ(find_least_common_domain_depth("yandex", "yandex"), 1);
    ASSERT_EQ(find_least_common_domain_depth("yandex.ru", "yandex.ru"), 1);
    ASSERT_EQ(find_least_common_domain_depth("sub.yandex.ru", "sub.yandex.ru"), 1);
    ASSERT_EQ(find_least_common_domain_depth("sub2.sub1.yandex.ru", "sub2.sub1.yandex.ru"), 1);
}

TEST(CommonDomainDepth, Empty) {
    ASSERT_EQ(find_least_common_domain_depth("", ""), 1);
    ASSERT_EQ(find_least_common_domain_depth("", "yandex"), 0);
    ASSERT_EQ(find_least_common_domain_depth("yandex", ""), 0);
}

TEST(CommonDomainDepth, Mismatch) {
    ASSERT_EQ(find_least_common_domain_depth("yandex.ru", "google.com"), 0);
    ASSERT_EQ(find_least_common_domain_depth("sub1.yandex.ru", "yandex.ru"), 0);
    ASSERT_EQ(find_least_common_domain_depth("yandex.ru", "subyandex.ru"), 0);
}

TEST(CommonDomainDepth, Subdomain) {
    ASSERT_EQ(find_least_common_domain_depth("yandex.ru", "sub1.yandex.ru"), 2);
    ASSERT_EQ(find_least_common_domain_depth("sub1.yandex.ru", "sub2.sub1.yandex.ru"), 2);
    ASSERT_EQ(find_least_common_domain_depth("yandex.ru", "sub2.sub1.yandex.ru"), 3);
}
