#include <mail/nwsmtp/src/delivery/async/error_code.h>
#include <mail/nwsmtp/src/error_code.h>
#include <mail/nwsmtp/src/smtp_client/error_code.h>
#include <mail/nwsmtp/src/mailfrom/error_code.h>
#include <mail/nwsmtp/src/types.h>

#include <gtest/gtest.h>
#include <gmock/gmock.h>

namespace {

using namespace testing;
using namespace NNwSmtp;
using EError = NNwSmtp::NSmtp::EError;

struct TestSmtpErrors: TestWithParam<std::tuple<TErrorCode, EError>> {
};

TEST_P(TestSmtpErrors, test_equivalent_error_code) {
    EXPECT_TRUE(std::get<0>(GetParam()) == make_error_condition(std::get<1>(GetParam())));
}

INSTANTIATE_TEST_SUITE_P(
    test_equivalent_error_code,
    TestSmtpErrors,
    Values(
        std::make_tuple(
            make_error_code(NAsyncDlv::EError::RpopAuthTempFail),
            EError::TempFail
        ),
        std::make_tuple(
            make_error_code(NAsyncDlv::EError::RpopAuthRejected),
            EError::Rejected
        ),
        std::make_tuple(
            make_error_code(NAsyncDlv::EError::AvirRejected),
            EError::Rejected
        ),
        std::make_tuple(
            make_error_code(NAsyncDlv::EError::MaliciousRejected),
            EError::Rejected
        ),
        std::make_tuple(
            make_error_code(NRcptTo::EError::Discard),
            EError::Discarded
        ),
        std::make_tuple(
            make_error_code(NAsyncDlv::EError::MaliciousDiscarded),
            EError::Discarded
        ),
        std::make_tuple(
            make_error_code(NAsyncDlv::EError::AvirDiscarded),
            EError::Discarded
        ),
        std::make_tuple(
            make_error_code(NRcptTo::EError::Reject),
            EError::Rejected
        ),
        std::make_tuple(
            make_error_code(NRcptTo::EError::RejectByRateSrv),
            EError::Rejected
        ),
        std::make_tuple(
            make_error_code(NRcptTo::EError::MaillistIsReadonly),
            EError::Rejected
        ),
        std::make_tuple(
            make_error_code(NRcptTo::EError::TooManyRecipients),
            EError::Rejected
        ),
        std::make_tuple(
            make_error_code(NAsyncDlv::EError::TooManyHeadersReject),
            EError::Rejected
        ),
        std::make_tuple(
            make_error_code(NAsyncDlv::EError::DeliveryRejected),
            EError::Rejected
        ),
        std::make_tuple(
            make_error_code(NAsyncDlv::EError::SenderIdRejected),
            EError::Rejected
        ),
        std::make_tuple(
            make_error_code(NNwSmtp::SmtpClient::EError::Rejected),
            EError::Rejected
        ),
        std::make_tuple(
            make_error_code(NRcptTo::EError::TempFail),
            EError::TempFail
        ),
        std::make_tuple(
            make_error_code(NAsyncDlv::EError::DkimSignTempFail),
            EError::TempFail
        ),
        std::make_tuple(
            make_error_code(NAsyncDlv::EError::DeliveryTempFail),
            EError::TempFail
        ),
        std::make_tuple(
            make_error_code(NAsyncDlv::EError::RouteTempFail),
            EError::TempFail
        ),
        std::make_tuple(
            make_error_code(SmtpClient::EError::TempFail),
            EError::TempFail
        ),
        std::make_tuple(
            make_error_code(NAsyncDlv::EError::SpamDiscarded),
            EError::Discarded
        ),
        std::make_tuple(
            make_error_code(NAsyncDlv::EError::SpamRejected),
            EError::Rejected
        ),
        std::make_tuple(
            make_error_code(NAsyncDlv::EError::SoTempFail),
            EError::TempFail
        ),
        std::make_tuple(
            make_error_code(NMailFromCommand::EError::MailAddrIsTooLong),
            EError::Rejected
        ),
        std::make_tuple(
            make_error_code(NMailFromCommand::EError::MailAddrIsInvalid),
            EError::Rejected
        ),
        std::make_tuple(
            make_error_code(NMailFromCommand::EError::MessageSizeIsInvalid),
            EError::Rejected
        ),
        std::make_tuple(
            make_error_code(NMailFromCommand::EError::MessageSizeExceedsLimit),
            EError::Rejected
        ),
        std::make_tuple(
            make_error_code(NMailFromCommand::EError::NotAuthorized),
            EError::Rejected
        ),
        std::make_tuple(
            make_error_code(NMailFromCommand::EError::AuthReject),
            EError::Rejected
        ),
        std::make_tuple(
            make_error_code(NMailFromCommand::EError::RejectAddrNotOwnedByAuthUser),
            EError::Rejected
        ),
        std::make_tuple(
            make_error_code(NMailFromCommand::EError::RejectAddrUserNotFound),
            EError::Rejected
        ),
        std::make_tuple(
            make_error_code(NMailFromCommand::EError::RejectRateSrv),
            EError::Rejected
        ),
        std::make_tuple(
            make_error_code(NMailFromCommand::EError::TempFail),
            EError::TempFail
        ),
        std::make_tuple(
            make_error_code(NAsyncDlv::EError::RfcFailRejected),
            EError::Rejected
        ),
        std::make_tuple(
            make_error_code(NAsyncDlv::EError::UrlRblRejected),
            EError::Rejected
        ),
        std::make_tuple(
            make_error_code(NAsyncDlv::EError::BadKarmaRejected),
            EError::Rejected
        ),
        std::make_tuple(
            make_error_code(NAsyncDlv::EError::MailLimitsRejected),
            EError::Rejected
        ),
        std::make_tuple(
            make_error_code(NAsyncDlv::EError::PddAdminKarmaRejected),
            EError::Rejected
        ),
        std::make_tuple(
            make_error_code(NAsyncDlv::EError::BouncesRejected),
            EError::Rejected
        ),
        std::make_tuple(
            make_error_code(NAsyncDlv::EError::SpamComplRejected),
            EError::Rejected
        ),
        std::make_tuple(
            make_error_code(NAsyncDlv::EError::RelayNotSet),
            EError::Rejected
        ),
        std::make_tuple(
            make_error_code(NAsyncDlv::EError::CycleDetected),
            EError::Rejected
        )
    )
);

} // namespace anonymous
