#pragma once

#include <ymod_httpclient/client.h>

namespace NTesting {

using yhttp::options;
using yhttp::request;
using yhttp::response;

class THttpClientMock : public yhttp::simple_call {
public:
    using task_context_ptr = yhttp::simple_call::task_context_ptr;
    using callback_type = yhttp::simple_call::callback_type;

    using TAsyncRunImpl = std::function<void(request, options, callback_type)>;

    explicit THttpClientMock(TAsyncRunImpl asyncRunImpl)
        : AsyncRunImpl(std::move(asyncRunImpl))
    {}

    response run(task_context_ptr, request) override;

    response run(task_context_ptr, request, const options&) override;

    void async_run(task_context_ptr, request, callback_type) override;

    void async_run(task_context_ptr, request, const options&, callback_type) override;

public:
    TAsyncRunImpl AsyncRunImpl;
    size_t CallCount = 0;
};

}  // namespace NTesting

