#pragma once

#include <ymod_httpclient/cluster_client.h>

#include <gtest/gtest.h>
#include <gmock/gmock.h>

#include <memory>

namespace NTesting {

struct TClusterClientMock : ymod_httpclient::cluster_call {

    using task_context_ptr = yhttp::simple_call::task_context_ptr;
    using callback_type = yhttp::simple_call::callback_type;

    MOCK_METHOD(void, async_run, (task_context_ptr, yhttp::request, callback_type));
    MOCK_METHOD(void, async_run, (task_context_ptr, yhttp::request,
        const ymod_httpclient::cluster_call::options&, callback_type
    ));
};

inline std::shared_ptr<testing::StrictMock<TClusterClientMock>> GetStrictMockedClusterClient() {
    return std::make_shared<testing::StrictMock<TClusterClientMock>>();
}

} // namespace NTesting
