#pragma once

#include <gmock/gmock.h>
#include <gtest/gtest.h>

#include <mail/nwsmtp/src/blackbox/bb_checks.h>
#include <mail/nwsmtp/src/mailfrom/check_bb/types.h>
#include <mail/nwsmtp/src/bb_result.h>

namespace NNwSmtp::NMailFromCheckBB {

static bool operator ==(const TResponse& lhs, const TResponse& rhs) {
    return lhs.BBResult.Suid == rhs.BBResult.Suid
        && lhs.BBResult.Karma == rhs.BBResult.Karma
        && lhs.BBResult.KarmaStatus == rhs.BBResult.KarmaStatus
        && lhs.BBResult.TimeStamp == rhs.BBResult.TimeStamp
        && lhs.BBResult.RegistrationDate == rhs.BBResult.RegistrationDate
        && lhs.BBResult.AuthAddr == rhs.BBResult.AuthAddr
        && lhs.BBResult.Country == rhs.BBResult.Country
        && lhs.BBResult.Uid == rhs.BBResult.Uid
        && lhs.BBResult.DefaultEmail == rhs.BBResult.DefaultEmail
        && lhs.BBResult.Domain == rhs.BBResult.Domain
        && lhs.BBResult.Db == rhs.BBResult.Db
        && lhs.BBResult.PhoneConfirmed == rhs.BBResult.PhoneConfirmed
        && lhs.BBResult.IsHosted == rhs.BBResult.IsHosted
        && lhs.BBResult.IsMaillist == rhs.BBResult.IsMaillist
        && lhs.BBResult.IsCorpList == rhs.BBResult.IsCorpList
        && lhs.BBResult.CatchAll == rhs.BBResult.CatchAll;
}

}
 
namespace NNwSmtp::NMailFromCheckBB::NTest {

struct TBBChecksMock : NBlackBox::IBBChecks {
    MOCK_METHOD(void, CheckRecipient, (TContextPtr, std::string, std::string, bool, bool, NBlackBox::IBBChecks::TCallback), (override));
    MOCK_METHOD(void, CheckMailFrom, (TContextPtr, std::string, std::string, NBlackBox::IBBChecks::TCallback), (override));
    MOCK_METHOD(void, CheckAuth, (TContextPtr, TAuthData authInfo, NBlackBox::IBBChecks::TCallback), (override));
};

}
