#include <mail/nwsmtp/src/mailfrom/error_code.h>
#include <mail/nwsmtp/src/types.h>

#include <gtest/gtest.h>

namespace {

using namespace testing;
using namespace NNwSmtp;
using EError = NNwSmtp::NMailFromCommand::EError;

struct TTestMailFromCommandErrors: TestWithParam<std::tuple<TErrorCode, EError>> {
};

TEST_P(TTestMailFromCommandErrors, TestEquivalentErrorCode) {
    EXPECT_TRUE(std::get<0>(GetParam()) == make_error_condition(std::get<1>(GetParam())));
}

INSTANTIATE_TEST_SUITE_P(
    TestEquivalentErrorCode,
    TTestMailFromCommandErrors,
    Values(
        std::make_tuple(
            make_error_code(NRateSrv::EError::Discard),
            EError::RejectRateSrv
        ),
        std::make_tuple(
            make_error_code(NRateSrv::EError::Reject),
            EError::RejectRateSrv
        )
    )
);

} // namespace anonymous
