#pragma once

#include <mail/ymod_mds/src/client.h>

#include <gtest/gtest.h>
#include <gmock/gmock.h>

namespace NTesting {

struct TMdsClientMock : NMds::TClient {
    MOCK_METHOD(void, Put, (NMds::TContext, const std::string&, const yplatform::zerocopy::segment&,
        NMds::ENsType, NMds::TGetPutCallback
    ));
    MOCK_METHOD(void, Put, (NMds::TContext, const std::string&, std::string,
        NMds::ENsType, NMds::TGetPutCallback
    ));
    MOCK_METHOD(void, Check, (NMds::TContext, const std::string&, NMds::TCheckDelCallback));
    MOCK_METHOD(void, Del, (NMds::TContext, const std::string&, NMds::TCheckDelCallback));
    MOCK_METHOD(void, Get, (NMds::TContext, const std::string&, NMds::TGetPutCallback));
};

} // namespace NTesting
