#include <mail/nwsmtp/src/nsls/make_response.h>
#include <mail/nwsmtp/src/nsls/types.h>
#include <mail/nwsmtp/src/nsls/types_reflection.h>

#include <gtest/gtest.h>

namespace NNwSmtp::NNsls {

static bool operator ==(const TNslsSuccessResponse& lhs, const TNslsSuccessResponse& rhs) {
    return boost::fusion::operator==(lhs, rhs);
}

static bool operator ==(const TNslsErrorResponse& lhs, const TNslsErrorResponse& rhs) {
    return boost::fusion::operator==(lhs, rhs);
}

static bool operator ==(const TResponse& lhs, const TResponse& rhs) {
    return boost::fusion::operator==(lhs, rhs);
}

} // namespace NNwSmtp::NNsls

namespace {

using namespace testing;
using namespace NNwSmtp::NNsls;

constexpr const char* MID = "mid";
constexpr const char* IMAP_ID = "imap_id";
constexpr const char* SUCCESS = "success";
constexpr const char* ERROR = "error";

TStoreResponse MakeStoreResponse(const std::string& status) {
    TStoreResponse response {};
    response.recipients.emplace_back(TRecipient {
        "george@pig.com",
        "1",
        ELocal::yes,
        TNotification {false, false, false},
        true,
        TDeliveryResult {MID, IMAP_ID, "stid", "mail_from", {}},
        status
    });
    return response;
}

TEST(TestMakeStoreResponse, for_unknown_status_store_result_should_return_error_status) {
    TResponse response;
    response.Status = ERROR;
    ASSERT_EQ(response, MakeResponse(MakeStoreResponse("tutu")));
}

TEST(TestMakeStoreResponse, for_decycled_status_store_result_should_return_success_status) {
    TResponse response;
    response.Status = SUCCESS;
    response.Success.IsDecycled = true;
    ASSERT_EQ(response, MakeResponse(MakeStoreResponse("decycled")));
}

TEST(TestMakeStoreResponse, for_deduplicated_status_store_result_should_return_success_status) {
    TResponse response;
    response.Status = SUCCESS;
    response.Success.IsDuplicate = true;
    response.Success.Mid = MID;
    ASSERT_EQ(response, MakeResponse(MakeStoreResponse("deduplicated")));
}

TEST(TestMakeStoreResponse, for_stored_status_store_result_should_return_success_status) {
    TResponse response;
    response.Status = SUCCESS;
    response.Success.Mid = MID;
    response.Success.ImapId = IMAP_ID;
    ASSERT_EQ(response, MakeResponse(MakeStoreResponse("stored")));
}

TEST(TestMakeStoreResponse, for_temp_error_status_store_result_should_return_error_status) {
    TResponse response;
    response.Status = ERROR;
    ASSERT_EQ(response, MakeResponse(MakeStoreResponse("temp_error")));
}

TEST(TestMakeStoreResponse, for_perm_error_status_store_result_should_return_error_status) {
    TResponse response;
    response.Status = ERROR;
    response.Error.IsPermanent = true;
    ASSERT_EQ(response, MakeResponse(MakeStoreResponse("perm_error")));
}

} // namespace anonymous
