#include <mail/nwsmtp/src/rcpt_to/error_code.h>
#include <mail/nwsmtp/src/types.h>

#include <gtest/gtest.h>

namespace {

using namespace testing;
using namespace NNwSmtp;
using EError = NNwSmtp::NRcptTo::EError;

struct TTestRcptToErrors: TestWithParam<std::tuple<TErrorCode, EError>> {
};

TEST_P(TTestRcptToErrors, TestEquivalentErrorCode) {
    EXPECT_TRUE(std::get<0>(GetParam()) == make_error_condition(std::get<1>(GetParam())));
}

INSTANTIATE_TEST_SUITE_P(
    TestEquivalentErrorCode,
    TTestRcptToErrors,
    Values(
        std::make_tuple(
            make_error_code(NRateSrv::EError::Discard),
            EError::Discard
        ),
        std::make_tuple(
            make_error_code(NRateSrv::EError::Reject),
            EError::RejectByRateSrv
        )
    )
);

} // namespace anonymous
