#pragma once

#include <mail/nwsmtp/src/big_ml/client.h>
#include <mail/nwsmtp/src/blackbox/bb_checks.h>
#include <mail/nwsmtp/src/ml/client.h>
#include <mail/nwsmtp/src/ratesrv/checks.h>
#include <mail/nwsmtp/src/router/router.h>

#include <gmock/gmock.h>
#include <gtest/gtest.h>

namespace NNwSmtp::NTest {

struct TMlMock: NML::IClient {
    MOCK_METHOD(void, Run, (TContextPtr, NML::TRequest, TCallback), (override));
};

struct TBigMlMock: NBigML::IClient {
    MOCK_METHOD(void, Run, (TContextPtr, NBigML::TRequest, TCallback), (override));
};

struct TAsyncCheckRecipientClientMock: NRateSrv::IAsyncCheckRecipientClient {
    MOCK_METHOD(void, Run, (TContextPtr, NRateSrv::TRcptRequest, TCallback), (override));
};

struct TBbChecksMock: NBlackBox::IBBChecks {
    MOCK_METHOD(void, CheckRecipient, (TContextPtr, std::string, std::string, bool, bool, TCallback), (override));
    MOCK_METHOD(void, CheckMailFrom, (TContextPtr, std::string, std::string, TCallback), (override));
    MOCK_METHOD(void, CheckAuth, (TContextPtr, TAuthData, TCallback), (override));
};

struct TRouterMock: Router {
    MOCK_METHOD(void, asyncRoute, (TContextPtr, const std::string&, Handler), (override));
};

} // namespace NNwSmtp::NTest
