#include "mocks.h"

#include <mail/nwsmtp/src/rcpt_to/rcpt_to.h>

#include <gmock/gmock.h>
#include <gtest/gtest.h>

namespace {

using namespace testing;
using namespace NNwSmtp;
using namespace NNwSmtp::NTest;
using namespace NNwSmtp::NRcptTo;

envelope_ptr MakeEnvelope() {
    auto envelopePtr = boost::make_shared<envelope>();
    envelopePtr->add_recipient("hello_darkness@my.old.friend", 301, false, "", "", "", "");
    return envelopePtr;
}

struct TTestRcptTo: Test {
    TTestRcptTo() {
        NNwSmtp::glog = std::make_shared<TLog>();
    }

    void RunRcptTo(TCallback cb) {
        TRcptToCommandPtr cmdPtr = std::make_shared<TRcptToCommand>(Config, MlMock, BigMlMock, CheckRecipientMock, BbChecksMock, RouterMock, IoContext);
        cmdPtr->Run(Ctx, Request, std::move(cb));
        IoContext.run();
    }

    TConfig Config;
    TRequest Request = {
        .RcptTo = "hello_darkness@my.old.friend",
        .Envelope = MakeEnvelope(),
    };
    std::shared_ptr<StrictMock<TMlMock>> MlMock = std::make_shared<StrictMock<TMlMock>>();
    std::shared_ptr<StrictMock<TBigMlMock>> BigMlMock = std::make_shared<StrictMock<TBigMlMock>>();
    std::shared_ptr<StrictMock<TAsyncCheckRecipientClientMock>> CheckRecipientMock = std::make_shared<StrictMock<TAsyncCheckRecipientClientMock>>();
    std::shared_ptr<StrictMock<TBbChecksMock>> BbChecksMock = std::make_shared<StrictMock<TBbChecksMock>>();
    std::shared_ptr<StrictMock<TRouterMock>> RouterMock = std::make_shared<StrictMock<TRouterMock>>();

    boost::asio::io_context IoContext;
    TContextPtr Ctx = boost::make_shared<TContext>("conn", "env", "cluster", "host");
};

TEST_F(TTestRcptTo, ForUserRejectedByRatesrvShouldReturnRejectError) {
    InSequence seq;
    EXPECT_CALL(*CheckRecipientMock, Run(_, _, _))
        .WillOnce(InvokeArgument<2>(NRateSrv::EError::Reject));

    RunRcptTo(
        [](TErrorCode ec, TResponse) {
            EXPECT_TRUE(ec);
            EXPECT_EQ(ec, EError::RejectByRateSrv);
        }
    );
}

TEST_F(TTestRcptTo, ForUserDiscardedByRatesrvShouldReturnDiscardError) {
    InSequence seq;
    EXPECT_CALL(*CheckRecipientMock, Run(_, _, _))
        .WillOnce(InvokeArgument<2>(NRateSrv::EError::Discard));

    RunRcptTo(
        [](TErrorCode ec, TResponse) {
            EXPECT_TRUE(ec);
            EXPECT_EQ(ec, EError::Discard);
        }
    );
}

} // namespace anonymous
