#include <mail/nwsmtp/src/recognizer/recognizer_impl.h>

#include <gtest/gtest.h>
#include <gmock/gmock.h>

#include <library/cpp/testing/unittest/tests_data.h>

using namespace NNwSmtp;
using namespace testing;

struct TRecognizerTest: Test {
    TRecognizerTest()
        : languageDict(GetWorkPath() + "/queryrec.dict")
        , languageWeights(GetWorkPath() + "/queryrec.weights")
        , encodingDict(GetWorkPath() + "/dict.dict")
    {
        recognizer.create(languageDict, languageWeights, encodingDict);
    }

    const std::string languageDict;
    const std::string languageWeights;
    const std::string encodingDict;
    TRecognizer recognizer;
};

TEST_F(TRecognizerTest, utfize_utf_string) {
    std::string domain = "admin@qq.com";
    std::string result = "admin@qq.com";
    ASSERT_EQ(recognizer.Utfize(domain), result);
}

TEST_F(TRecognizerTest, utfize_base64_string) {
    std::string domain = "=?utf-8?b?YWRtaW5AcXEuY29t?=";
    std::string result = "admin@qq.com";
    ASSERT_EQ(recognizer.Utfize(domain), result);
}

TEST_F(TRecognizerTest, utfize_base64_rfc_format_header_from) {
    std::string domain = "=?UTF-8?B?Ij0/VVRGLTg/Qj8wSmpRdmRHQzBMWFJnTkM5MExYUmdpRFF2TkN3MFlEUXV0QzE=?=\r\n"
        "=?UTF-8?B?MFlMUXVOQzkwTFBRdnRDeTBMN1F0U0RRc0E9PT89CiA9P1VURi04P0I/MExQUXQ=?=\r\n"
        "=?UTF-8?B?ZEM5MFlMUmdkR0MwTExRdmlCV2IzSjBaWGc9Pz0iIDxhZG1pbkBleGFtcGxlLmM=?=\r\n"
        "=?UTF-8?B?b20+?=";
    std::string result = "\"=?UTF-8?B?0JjQvdGC0LXRgNC90LXRgiDQvNCw0YDQutC10YLQuNC90LPQvtCy0L7QtSDQsA==?=\n =?UTF-8?B?0LPQtdC90YLRgdGC0LLQviBWb3J0ZXg=?=\" <admin@example.com>";
    ASSERT_EQ(recognizer.Utfize(domain), result);
}
