#include "resolver_mock.h"

#include <mail/nwsmtp/src/resolver/client_impl.h>
#include <mail/nwsmtp/src/types.h>
#include <mail/nwsmtp/ut/test_with_spawn.h>

#include <mail/yplatform/include/yplatform/reactor/reactor.h>

#include <gtest/gtest.h>
#include <gmock/gmock.h>

#include <boost/asio.hpp>

namespace {

using namespace testing;
using namespace NTesting;
using namespace NNwSmtp;
using namespace NNwSmtp::NDns;

struct TResolverClientTest: TTestWithSpawn {
    yplatform::reactor Reactor;

    const std::shared_ptr<StrictMock<TResolverMock>> ResolverModuleClient =
        std::make_shared<StrictMock<TResolverMock>>(Reactor);
    const std::shared_ptr<TResolverClient> ResolverClient = std::make_shared<TResolverClient>(ResolverModuleClient, Io);

    TContextPtr Context = boost::make_shared<NNwSmtp::TContext>("","","","");

    template <typename THandler>
    std::string ResolveIp(
        THandler handler,
        std::string ip
    ) {
        boost::asio::async_completion<
            THandler,
            void(TErrorCode, std::string)
        > init(handler);
        ResolverClient->ResolveIp(Context, ip, init.completion_handler);
        return init.result.get();
    }
};

TEST_F(TResolverClientTest, for_resolve_request_ended_with_error_should_return_error) {
    WithSpawn([this](boost::asio::yield_context yield) {

        EXPECT_CALL(*ResolverModuleClient, AsyncResolveIp(_, "228", _))
            .WillOnce(InvokeArgument<2>(ymod_httpclient::http_error::code::ssl_error, std::string{}));

        TErrorCode ec;
        auto result = ResolveIp(yield[ec], "228");
        ASSERT_TRUE(ec);
        EXPECT_EQ(ec, ymod_httpclient::http_error::code::ssl_error);
    });
}

TEST_F(TResolverClientTest, for_good_resolve_request_should_return_host_name) {
    WithSpawn([this](boost::asio::yield_context yield) {

        EXPECT_CALL(*ResolverModuleClient, AsyncResolveIp(_, "228", _))
            .WillOnce(InvokeArgument<2>(TErrorCode {}, std::string{"hostname"}));

        TErrorCode ec;
        auto result = ResolveIp(yield[ec], "228");
        ASSERT_FALSE(ec);
        EXPECT_EQ(result, "hostname");
    });
}

} // namespace anonymous
