#include <mail/nwsmtp/src/delivery/sync/types.h>
#include <mail/nwsmtp/src/web/restore/request.h>
#include <mail/nwsmtp/src/web/restore/make_args.h>


#include <gtest/gtest.h>
#include <gmock/gmock.h>

namespace NNwSmtp::NDlv {

static bool operator ==(const TLabels& lhs, const TLabels& rhs) {
    return lhs.System == rhs.System
        && lhs.Imap == rhs.Imap
        && lhs.Symbol == rhs.Symbol
        && lhs.Lids == rhs.Lids
        && lhs.System == rhs.System
        && lhs.Symbol == rhs.Symbol;
}

static bool operator ==(const TMailInfo& lhs, const TMailInfo& rhs) {
    return lhs.Fid == rhs.Fid
        && lhs.ReceivedDate == rhs.ReceivedDate
        && lhs.Labels == rhs.Labels
        && lhs.ExternalImapId == rhs.ExternalImapId
        && lhs.OldMid == rhs.OldMid
        && lhs.Tab == rhs.Tab
        && lhs.Stid == rhs.Stid;
}

static bool operator ==(const TUserInfo& lhs, const TUserInfo& rhs) {
    return lhs.Uid == rhs.Uid
        && lhs.Email == rhs.Email;
}

} // namespace NNwSmtp::NDlv

namespace {

using namespace testing;
using namespace NNwSmtp;
using namespace NNwSmtp::NWeb::NRestore;

TRequest MakeRequest(
    const std::string& fid,
    const std::string& stid,
    const std::string& tab,
    const std::string& email
) {
    return {
        TUserInfo{email},
        TMailInfo{stid, fid, tab, 228, {"lid1", "lid2"}, {{"so"}}, {{"seen"}}}
    };
}

TEST(TRestoreMakeArgsTest, for_request_with_all_fields_should_return_mail_info) {
    auto request = MakeRequest("fid", "stid", "tab", "email");
    auto mailInfo = NDlv::TMailInfo{};
    mailInfo.Fid = "fid";
    mailInfo.ReceivedDate = 228;
    mailInfo.Labels = NDlv::TLabels{
        .System = {{"so"}},
        .Symbol = {{"seen"}},
        .Lids = {{"lid1", "lid2"}},
    };
    mailInfo.Stid = "stid";
    mailInfo.Tab = "tab";
    EXPECT_EQ(MakeMailInfo(request), mailInfo);
}

TEST(TRestoreMakeArgsTest, for_request_without_fid_should_throw_exception) {
    auto request = MakeRequest("", "stid", "tab", "email");
    EXPECT_THROW(MakeMailInfo(request), std::invalid_argument);
}

TEST(TRestoreMakeArgsTest, for_request_without_stid_should_throw_exception) {
    auto request = MakeRequest("fid", "", "tab", "email");
    EXPECT_THROW(MakeMailInfo(request), std::invalid_argument);
}

TEST(TRestoreMakeArgsTest, for_request_without_tab_should_throw_exception) {
    auto request = MakeRequest("fid", "stid", "", "email");
    EXPECT_THROW(MakeMailInfo(request), std::invalid_argument);
}

TEST(TRestoreMakeArgsTest, for_request_and_uid_should_return_user_info) {
    auto request = MakeRequest("fid", "stid", "tab", "email");
    auto userInfo = NDlv::TUserInfo{};
    userInfo.Email = "email";
    userInfo.Uid = "uid";
    EXPECT_EQ(MakeUserInfo(request, "uid"), userInfo);
}

TEST(TRestoreMakeArgsTest, for_request_without_email_should_throw_exception) {
    auto request = MakeRequest("fid", "stid", "tab", "");
    EXPECT_THROW(MakeUserInfo(request, "uid"), std::invalid_argument);
}

TEST(TRestoreMakeArgsTest, for_request_and_empty_uid_throw_exception) {
    auto request = MakeRequest("fid", "stid", "tab", "email");
    EXPECT_THROW(MakeUserInfo(request, ""), std::invalid_argument);
}

} // namespace anonymous
