#include <mail/nwsmtp/src/delivery/sync/errors.h>
#include <mail/nwsmtp/src/web/restore/make_response.h>
#include <mail/nwsmtp/src/web/restore/response.h>
#include <mail/nwsmtp/src/web/restore/reflection.h>
#include <mail/nwsmtp/src/types.h>

#include <boost/fusion/include/equal_to.hpp>

#include <gtest/gtest.h>
#include <gmock/gmock.h>

namespace NNwSmtp::NWeb::NRestore {

static bool operator ==(const TErrorResponse& lhs, const TErrorResponse& rhs) {
    return boost::fusion::operator==(lhs, rhs);
}

}

namespace {

using namespace testing;
using namespace NNwSmtp;
using namespace NNwSmtp::NWeb::NRestore;
using EError = NNwSmtp::NDlv::EError;

struct TTestMakeErrorResponse: TestWithParam<std::tuple<TErrorCode, TErrorResponse>> {
};

TEST_P(TTestMakeErrorResponse, test_make_error_response) {
    EXPECT_EQ(
        MakeErrorResponse(std::get<0>(GetParam()), {"mid", ""}),
        std::get<1>(GetParam())
    );
}

INSTANTIATE_TEST_SUITE_P(
    test_make_error_response,
    TTestMakeErrorResponse,
    Values(
        std::make_tuple(
            make_error_code(EError::BadMessage),
            TErrorResponse {"RestoreError", "bad message"}
        ),
        std::make_tuple(
            make_error_code(EError::CycleDetected),
            TErrorResponse {"RestoreError", "loop detected"}
        ),
        std::make_tuple(
            make_error_code(EError::DuplicateFound),
            TErrorResponse {"DuplicateError", "mid"}
        ),
        std::make_tuple(
            make_error_code(EError::Exception),
            TErrorResponse {"RestoreError", "exception"}
        ),
        std::make_tuple(
            make_error_code(EError::MdsError),
            TErrorResponse {"ServiceUnavaliable", "mds temporary error"}
        ),
        std::make_tuple(
            make_error_code(EError::SOError),
            TErrorResponse {"ServiceUnavaliable", "so temporary error"}
        ),
        std::make_tuple(
            make_error_code(EError::NslsTemporaryError),
            TErrorResponse {"ServiceUnavaliable", "nsls temporary error"}
        ),
        std::make_tuple(
            make_error_code(EError::NslsPermanentError),
            TErrorResponse {"NslsPermanentError", "nsls permanent error"}
        ),
        std::make_tuple(
            make_error_code(EError::StorageMailNotFound),
            TErrorResponse {"StorageMailNotFound", "message not found in the storage"}
        ),
        std::make_tuple(
            make_error_code(EError::InvalidFid),
            TErrorResponse {"InvalidFid", "nsls permanent error"}
        )
    )
);

} // namespace anonymous
