#include <mail/nwsmtp/src/delivery/sync/types.h>
#include <mail/nwsmtp/src/web/save/make_args.h>

#include <mail/ymod_webserver/include/ymod_webserver/request.h>

#include <gtest/gtest.h>
#include <gmock/gmock.h>

namespace NNwSmtp::NDlv {

static bool operator ==(const TLabels& lhs, const TLabels& rhs) {
    return lhs.System == rhs.System
        && lhs.Imap == rhs.Imap
        && lhs.Symbol == rhs.Symbol
        && lhs.Lids == rhs.Lids;
}

static bool operator ==(const TMailInfo& lhs, const TMailInfo& rhs) {
    return lhs.Fid == rhs.Fid
        && lhs.ReceivedDate == rhs.ReceivedDate
        && lhs.Labels == rhs.Labels
        && lhs.ExternalImapId == rhs.ExternalImapId
        && lhs.OldMid == rhs.OldMid
        && lhs.Tab == rhs.Tab
        && lhs.Stid == rhs.Stid;
}

static bool operator ==(const TUserInfo& lhs, const TUserInfo& rhs) {
    return lhs.Uid == rhs.Uid
        && lhs.Email == rhs.Email;
}

static bool operator ==(const TOptions& lhs, const TOptions& rhs) {
    return lhs.EnablePush == rhs.EnablePush
        && lhs.DetectSpam == rhs.DetectSpam
        && lhs.DetectVirus == rhs.DetectVirus
        && lhs.DetectCycle == rhs.DetectCycle
        && lhs.UseFilters == rhs.UseFilters
        && lhs.AllowDuplicates == rhs.AllowDuplicates
        && lhs.SoOut == rhs.SoOut
        && lhs.SkipMetaMsg == rhs.SkipMetaMsg
        && lhs.DlvType == rhs.DlvType;
}

} // namespace NNwSmtp::NDlv

namespace {

using namespace testing;
using namespace NNwSmtp;
using namespace NNwSmtp::NWeb;
using namespace NNwSmtp::NWeb::NSave;

TRequest MakeRequest(std::string receivedDate = "") {
    TRequest request = boost::make_shared<ymod_webserver::request>();
    request->url.params = {
        {"fid", "fid"},
        {"received_date", receivedDate},
        {"old_mid", "old_mid"},
        {"lid", "lid1"},
        {"lid", "lid2"},
        {"system", "system1"},
        {"system", "system2"},
        {"symbol", "symbol1"},
        {"symbol", "symbol2"},
        {"detect_virus", "1"},
        {"detect_spam", "1"}
    };
    return request;
}

TEST(TSaveMakeArgsTest, for_request_with_all_fields_should_return_mail_info) {
    auto mailInfo = NDlv::TMailInfo{
        .Fid = "fid",
        .ReceivedDate = 228,
        .Labels = NDlv::TLabels{
            .System = std::vector<std::string>{"system1", "system2"},
            .Symbol = std::vector<std::string>{"symbol1", "symbol2"},
            .Lids = std::vector<std::string>{"lid1", "lid2"}
        },
        .OldMid = "old_mid",
    };
    EXPECT_EQ(MakeMailInfo(MakeRequest("228")), mailInfo);
}

TEST(TSaveMakeArgsTest, for_request_with_not_numeric_received_date_should_throw_exception) {
    EXPECT_THROW(MakeMailInfo(MakeRequest("")), std::invalid_argument);
}

TEST(TSaveMakeArgsTest, for_request_without_email_should_throw_exception) {
    EXPECT_THROW(MakeUserInfo("", "uid"), std::invalid_argument);
}

TEST(TSaveMakeArgsTest, for_request_without_uid_should_throw_exception) {
    EXPECT_THROW(MakeUserInfo("email", ""), std::invalid_argument);
}

TEST(TSaveMakeArgsTest, for_request_with_email_and_uid_should_return_user_info) {
    auto userInfo = NDlv::TUserInfo{.Uid = "uid", .Email = "email"};
    EXPECT_EQ(MakeUserInfo("email", "uid"), userInfo);
}

TEST(TSaveMakeArgsTest, for_request_should_return_options) {
    auto options = NDlv::TOptions{
        .DetectSpam = true,
        .DetectVirus = true,
        .SoOut = true,
        .SkipMetaMsg = true,
        .DlvType = NDlv::EDlvType::Save
    };
    EXPECT_EQ(MakeOptions(MakeRequest()), options);
}

} // namespace anonymous
