#include <mail/nwsmtp/src/delivery/sync/errors.h>
#include <mail/nwsmtp/src/web/save/make_response.h>
#include <mail/nwsmtp/src/web/save/response.h>
#include <mail/nwsmtp/src/web/save/reflection.h>
#include <mail/nwsmtp/src/types.h>

#include <boost/fusion/include/equal_to.hpp>

#include <gtest/gtest.h>
#include <gmock/gmock.h>

namespace NNwSmtp::NWeb::NSave {

static bool operator ==(const TResponse& lhs, const TResponse& rhs) {
    return boost::fusion::operator==(lhs, rhs);
}

}

namespace {

using namespace testing;
using namespace NNwSmtp;
using namespace NNwSmtp::NWeb::NSave;
using EError = NNwSmtp::NDlv::EError;

struct TTestMakeResponse: TestWithParam<std::tuple<TErrorCode, TResponse>> {
};

TEST_P(TTestMakeResponse, test_make_response) {
    EXPECT_EQ(
        MakeResponse(std::get<0>(GetParam())),
        std::get<1>(GetParam())
    );
}

INSTANTIATE_TEST_SUITE_P(
    test_make_response,
    TTestMakeResponse,
    Values(
        std::make_tuple(
            make_error_code(EError::BadMessage),
            TResponse {"SendMessageFailed", "", "bad message"}
        ),
        std::make_tuple(
            make_error_code(EError::CycleDetected),
            TResponse {"SendMessageFailed", "", "loop detected"}
        ),
        std::make_tuple(
            make_error_code(EError::DuplicateFound),
            TResponse {"SendMessageFailed", "", "duplicate found"}
        ),
        std::make_tuple(
            make_error_code(EError::Exception),
            TResponse {"SendMessageFailed", "", "exception"}
        ),
        std::make_tuple(
            make_error_code(EError::NslsPermanentError),
            TResponse {"SendMessageFailed", "", "nsls permanent error"}
        ),
        std::make_tuple(
            make_error_code(EError::MdsError),
            TResponse {"ServiceUnavaliable", "", "mds temporary error"}
        ),
        std::make_tuple(
            make_error_code(EError::SOError),
            TResponse {"ServiceUnavaliable", "", "so temporary error"}
        ),
        std::make_tuple(
            make_error_code(EError::AvirError),
            TResponse {"ServiceUnavaliable", "", "avir temporary error"}
        ),
        std::make_tuple(
            make_error_code(EError::NslsTemporaryError),
            TResponse {"ServiceUnavaliable", "", "nsls temporary error"}
        ),
        std::make_tuple(
            make_error_code(EError::Virus),
            TResponse {"Virus", "", "virus message"}
        ),
        std::make_tuple(
            make_error_code(EError::Spam),
            TResponse {"Spam", "", "spam message"}
        ),
        std::make_tuple(
            make_error_code(EError::Malicious),
            TResponse {"StrongSpam", "", "malicious spam message"}
        ),
        std::make_tuple(
            make_error_code(EError::InvalidFid),
            TResponse {"SendMessageFailed", "", "nsls permanent error"}
        )
    )
);

} // namespace anonymous
